% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BIARfit}
\alias{BIARfit}
\title{Fitted Values of BIAR model}
\usage{
BIARfit(phiValues, y1, y2, t, yerr1, yerr2, zeroMean = TRUE)
}
\arguments{
\item{phiValues}{An array with the parameters of the BIAR model. The elements of the array are, in order, the autocorrelation and the cross correlation parameter of the BIAR model.}

\item{y1}{Array with the observations of the first time series of the BIAR process.}

\item{y2}{Array with the observations of the second time series of the BIAR process.}

\item{t}{Array with the irregular observational times.}

\item{yerr1}{Array with the measurements error standard deviations of the first time series of the BIAR process.}

\item{yerr2}{Array with the measurements error standard deviations of the second time series of the BIAR process.}

\item{zeroMean}{logical; if TRUE, the array y has zero mean; if FALSE, y has a mean different from zero.}
}
\value{
A list with the following components:
\itemize{
\item{rho}{ Estimated value of the contemporary correlation coefficient.}
\item{innov.var}{ Estimated value of the innovation variance.}
\item{fitted}{ Fitted values of the BIAR model.}
\item{fitted.state}{ Fitted state values of the BIAR model.}
\item{Lambda}{ Lambda value estimated by the BIAR model at the last time point.}
\item{Theta}{ Theta array estimated by the BIAR model at the last time point.}
\item{Sighat}{ Covariance matrix estimated by the BIAR model at the last time point.}
\item{Qt}{ Covariance matrix of the state equation estimated by the BIAR model at the last time point.}
}
}
\description{
Fit a BIAR model to a bivariate irregularly observed time series.
}
\examples{
\donttest{
n=80
set.seed(6714)
st<-gentime(n)
x=BIARsample(n=n,phiR=0.9,phiI=0.3,st=st,rho=0.9)
y=x$y
y1=y/apply(y,1,sd)
yerr1=rep(0,n)
yerr2=rep(0,n)
biar=BIARkalman(y1=y1[1,],y2=y1[2,],t=st,delta1 = yerr1,delta2=yerr2)
biar
predbiar=BIARfit(phiValues=c(biar$phiR,biar$phiI),y1=y1[1,],y2=y1[2,],t=st,yerr1
 = rep(0,length(y[1,])),yerr2=rep(0,length(y[1,])))
rho=predbiar$rho
print(rho)
yhat=predbiar$fitted
}
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{BIARsample}}, \code{\link{BIARphikalman}}, \code{\link{BIARkalman}}
}
