% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F035.volcano.ma.plot.R
\name{volcano.ma.plot}
\alias{volcano.ma.plot}
\title{Create MA and Volcano plots.}
\usage{
volcano.ma.plot(x = NULL, sig.value = "padj", sig.line = 0.1,
  plot.type = "volcano", x.limit = 2, y.limit = 2,
  limit.force = FALSE, scale.ax = TRUE, dot.size = 1.75,
  dot.transparency = 0.5, dot.col = c("#E64B35", "#3182bd", "#636363"),
  interactive = TRUE, out.name = "plot")
}
\arguments{
\item{x}{A data frame containing differential expression (DE) analysis results.}

\item{sig.value}{Choose from "pval" or "padj", default = "padj".}

\item{sig.line}{A number to draw the line for the significant genes based on sig.value type, default = 0.1.}

\item{plot.type}{Choose from "ma" or "volcano", default = "volcano".}

\item{x.limit}{A number to set a limit for the x axis.}

\item{y.limit}{A number to set a limit for the y axis.}

\item{limit.force}{If set to TRUE the x.limit and y.limit will be forced, default = FALSE.}

\item{scale.ax}{If set to TRUE the y axis will be scaled to include all the points, default = TRUE.}

\item{dot.size}{A number for the size of the points in the plot, default = 1.75.}

\item{dot.transparency}{Color transparency for points in "scatterplot" and "boxplot", default = 0.5.}

\item{dot.col}{A set of three colors for the points in the volcano plot, default = c("#E64B35","#3182bd","#636363").}

\item{interactive}{If set to TRUE an interactive HTML file will be created, default = TRUE.}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "plot".}
}
\value{
Plots
}
\description{
This function takes the result of differential expression (DE) analysis and provides MA and volcano plots.
}
\examples{

diff.res <- run.diff.exp(demo.obj, de.by = "clusters", cond.1 = c(1), cond.2 = c(2))

volcano.ma.plot(diff.res,
              sig.value = "pval",
              sig.line = 0.05,
              plot.type = "volcano",
              interactive = FALSE)

volcano.ma.plot(diff.res,
             sig.value = "pval",
             sig.line = 0.05,
             plot.type = "ma",
             interactive = FALSE)

}
