\name{iForecast}
\alias{iForecast}

\encoding{latin1}

\title{Extract predictions and class probabilities from train objects}

\description{
It generates both the static and recursive time series plots of machine learning prediction object generated by ttsCaret, ttsAutoML and ttsLSTM.
}

\usage{
iForecast(Model,newdata,type)
}

\arguments{
  \item{Model}{
Object of trained model.
}


  \item{newdata}{The dataset for pediction, the column names must be the same as the trained data.

}

\item{type}{ If type="staticfit", it computes the direct (static) forecasting values of insample model fit; if type="recursive", it computes the recursive (dynamic) forecasting values of insample model; for recursive forecasts, AR term is required.
}

}


\details{

This function generates forecasts of ttsCaret,ttsAutoML, and ttsLSTM.
}



\value{
\item{prediction}{The forecasted time series}
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
## Machine Learning by library(caret)
#Case 1. Low frequency
data("macrodata")
dep <- macrodata[569:669,"unrate",drop=FALSE]
ind <- macrodata[569:669,-1,drop=FALSE]
train.end <- "2018-12-01"# Choosing the end dating of train

models <- c("svm","rf","rpart","gamboost","BstLm","bstSm","blackboost")[1]
type <- c("none","trend","season","both")[1]
Caret <- ttsCaret(y=dep, x=ind, arOrder=c(1), xregOrder=c(1),
 method=models, tuneLength =1, train.end, type=type,
 trControl= trainControl(method = "cv"))
 testData1 <- window(Caret$data,start="2019-01-01",end=end(Caret$data))
P1 <- iForecast(Model=Caret,newdata=testData1,type="staticfit")
P2 <- iForecast(Model=Caret,newdata=testData1,type="recursive")

#tail(cbind(testData1[,1],P1,P2))



}

