/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.FisherFDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class FisherFGen
extends RandomVariateGen {
    protected int n = -1;
    protected int m = -1;

    public FisherFGen(RandomStream s, int n, int m) {
        super(s, new FisherFDist(n, m));
        this.setParams(n, m);
    }

    public FisherFGen(RandomStream s, FisherFDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getN(), dist.getM());
        }
    }

    public static double nextDouble(RandomStream s, int n, int m) {
        return FisherFDist.inverseF(n, m, 15, s.nextDouble());
    }

    public int getN() {
        return this.n;
    }

    public int getM() {
        return this.m;
    }

    protected void setParams(int n, int m) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.m = m;
        this.n = n;
    }
}

