/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.StochasticProcess;

public class GammaProcess
extends StochasticProcess {
    protected static final double EPS = 1.0E-15;
    protected boolean usesAnti = false;
    protected RandomStream stream;
    protected GammaGen Ggen;
    protected double mu;
    protected double nu;
    protected double muOverNu;
    protected double mu2OverNu;
    protected double[] mu2dtOverNu;

    protected void setLarger(double[] path, int left, int mid, int right) {
        double myEps = path[left] >= 0.0 ? 1.0E-15 : -1.0E-15;
        path[mid] = path[left] * (1.0 + myEps);
        if (path[mid] >= path[right]) {
            path[right] = path[mid] * (1.0 + myEps);
        }
    }

    protected double setLarger(double[] path, int left, int right) {
        double myEps = path[left] >= 0.0 ? 1.0E-15 : -1.0E-15;
        double s = path[left] * (1.0 + myEps);
        if (s >= path[right]) {
            path[right] = s * (1.0 + myEps);
        }
        return s;
    }

    protected double setLarger(double v) {
        if (v >= 0.0) {
            return v * 1.000000000000001 + 2.220446049250313E-16;
        }
        return v * 0.999999999999999;
    }

    public GammaProcess(double s0, double mu, double nu, RandomStream stream) {
        this(s0, mu, nu, new GammaGen(stream, 1.0));
    }

    public GammaProcess(double s0, double mu, double nu, GammaGen Ggen) {
        this.mu = mu;
        this.nu = nu;
        this.x0 = s0;
        this.Ggen = Ggen;
        this.stream = Ggen.getStream();
    }

    public double nextObservation() {
        double s;
        double v = s = this.path[this.observationIndex];
        if ((s += GammaGen.nextDouble(this.stream, this.mu2dtOverNu[this.observationIndex], this.muOverNu)) <= v) {
            s = this.setLarger(v);
        }
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.path[this.observationIndex] = s;
        return s;
    }

    public double nextObservation(double nextT) {
        double s;
        double v = s = this.path[this.observationIndex];
        double previousT = this.t[this.observationIndex];
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.t[this.observationIndex] = nextT;
        double dt = nextT - previousT;
        if ((s += GammaGen.nextDouble(this.stream, this.mu2OverNu * dt, this.muOverNu)) <= v) {
            s = this.setLarger(v);
        }
        this.path[this.observationIndex] = s;
        return s;
    }

    public double[] generatePath() {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            double v = s;
            if (v <= (s += GammaGen.nextDouble(this.stream, this.mu2dtOverNu[i], this.muOverNu))) {
                s = this.setLarger(v);
            }
            this.path[i + 1] = s;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            double v = s;
            if (v <= (s += GammaDist.inverseF(this.mu2dtOverNu[i], this.muOverNu, 10, uniform01[i]))) {
                s = this.setLarger(v);
            }
            this.path[i + 1] = s;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public void setParams(double s0, double mu, double nu) {
        this.x0 = s0;
        this.mu = mu;
        this.nu = nu;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public double getMu() {
        return this.mu;
    }

    public double getNu() {
        return this.nu;
    }

    public void setStream(RandomStream stream) {
        this.stream = stream;
        this.Ggen.setStream(stream);
    }

    public RandomStream getStream() {
        return this.stream;
    }

    protected void init() {
        super.init();
        this.muOverNu = this.mu / this.nu;
        this.mu2OverNu = this.mu * this.mu / this.nu;
        this.mu2dtOverNu = new double[this.d];
        if (this.observationTimesSet) {
            for (int i = 0; i < this.d; ++i) {
                this.mu2dtOverNu[i] = this.mu2OverNu * (this.t[i + 1] - this.t[i]);
            }
        }
    }
}

