/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistribution2Dim;

public class BiNormalDist
extends ContinuousDistribution2Dim {
    protected int ndigit;
    protected double mu1;
    protected double mu2;
    protected double sigma1;
    protected double sigma2;
    protected double rho;
    protected double racRho;
    protected double detS;
    protected static final double RHO_SMALL = 1.0E-8;
    private static final double[] Z = new double[]{0.04691008, 0.23076534, 0.5, 0.76923466, 0.95308992};
    private static final double[] W = new double[]{0.018854042, 0.038088059, 0.0452707394, 0.038088059, 0.018854042};
    private static final double[] AGauss = new double[]{-0.72657601, 0.71070688, -0.142248368, 0.127414796};

    public BiNormalDist(double rho) {
        this.setParams(0.0, 1.0, 0.0, 1.0, rho);
    }

    public BiNormalDist(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        this.setParams(mu1, sigma1, mu2, sigma2, rho);
    }

    public double density(double x, double y) {
        if (Math.abs(this.rho) == 1.0) {
            throw new IllegalArgumentException("|rho| = 1");
        }
        double X = (x - this.mu1) / this.sigma1;
        double Y = (y - this.mu2) / this.sigma2;
        double T = (X * X - 2.0 * this.rho * X * Y + Y * Y) / (2.0 * this.racRho * this.racRho);
        return Math.exp(-T) / this.detS;
    }

    public static double density(double x, double y, double rho) {
        return BiNormalDist.density(0.0, 1.0, x, 0.0, 1.0, y, rho);
    }

    public static double density(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(rho) >= 1.0) {
            throw new IllegalArgumentException("|rho| >= 1");
        }
        double X = (x - mu1) / sigma1;
        double Y = (y - mu2) / sigma2;
        double fRho = (1.0 - rho) * (1.0 + rho);
        double T = (X * X - 2.0 * rho * X * Y + Y * Y) / (2.0 * fRho);
        return Math.exp(-T) / (Math.PI * 2 * sigma1 * sigma2 * Math.sqrt(fRho));
    }

    protected static double Gauss(double z) {
        double x = 1.0 / (1.0 + 0.23164189 * Math.abs(z));
        double G = 0.53070271;
        for (int i = 0; i < 4; ++i) {
            G = G * x + AGauss[i];
        }
        G = G * x * Math.exp(-z * z / 2.0);
        if (z > 0.0) {
            G = 1.0 - G;
        }
        return G;
    }

    protected static double specialCDF(double x, double y, double rho, double xbig) {
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        if (x == 0.0 && y == 0.0) {
            return 0.25 + Math.asin(rho) / (Math.PI * 2);
        }
        if (rho == 1.0) {
            if (y < x) {
                x = y;
            }
            return NormalDist.cdf01(x);
        }
        if (rho == -1.0) {
            if (y <= -x) {
                return 0.0;
            }
            return NormalDist.cdf01(x) - NormalDist.cdf01(-y);
        }
        if (Math.abs(rho) < 1.0E-8) {
            return NormalDist.cdf01(x) * NormalDist.cdf01(y);
        }
        if (x <= -xbig || y <= -xbig) {
            return 0.0;
        }
        if (x >= xbig) {
            return NormalDist.cdf01(y);
        }
        if (y >= xbig) {
            return NormalDist.cdf01(x);
        }
        return -2.0;
    }

    public static double cdf(double x, double y, double rho) {
        double bvn = BiNormalDist.specialCDF(x, y, rho, 20.0);
        if (bvn >= 0.0) {
            return bvn;
        }
        bvn = 0.0;
        double h1 = -x;
        double h2 = -y;
        double h12 = (h1 * h1 + h2 * h2) / 2.0;
        if (Math.abs(rho) >= 0.7) {
            double h3;
            double r2 = (1.0 - rho) * (1.0 + rho);
            double r3 = Math.sqrt(r2);
            if (rho < 0.0) {
                h2 = -h2;
            }
            double h7 = (h3 = h1 * h2) < 300.0 ? Math.exp(-h3 / 2.0) : 0.0;
            if (r2 != 0.0) {
                double h6 = Math.abs(h1 - h2);
                double h5 = h6 * h6 / 2.0;
                double aa = 0.5 - h3 / 8.0;
                double ab = 3.0 - 2.0 * aa * h5;
                bvn = 0.13298076 * (h6 /= r3) * ab * (1.0 - BiNormalDist.Gauss(h6)) - Math.exp(-h5 / r2) * (ab + aa * r2) * 0.053051647;
                for (int i = 0; i < 5; ++i) {
                    double r1 = r3 * Z[i];
                    double rr = r1 * r1;
                    r2 = Math.sqrt(1.0 - rr);
                    bvn -= W[i] * Math.exp(-h5 / rr) * (Math.exp(-h3 / (1.0 + r2)) / r2 / h7 - 1.0 - aa * rr);
                }
            }
            if (rho > 0.0) {
                bvn = bvn * r3 * h7 + (1.0 - BiNormalDist.Gauss(Math.max(h1, h2)));
            } else if (rho < 0.0) {
                bvn = (h1 < h2 ? BiNormalDist.Gauss(h2) - BiNormalDist.Gauss(h1) : 0.0) - bvn * r3 * h7;
            }
        } else {
            double h3 = h1 * h2;
            for (int i = 0; i < 5; ++i) {
                double r1 = rho * Z[i];
                double r2 = 1.0 - r1 * r1;
                bvn += W[i] * Math.exp((r1 * h3 - h12) / r2) / Math.sqrt(r2);
            }
            bvn = (1.0 - BiNormalDist.Gauss(h1)) * (1.0 - BiNormalDist.Gauss(h2)) + rho * bvn;
        }
        if (bvn <= 0.0) {
            return 0.0;
        }
        if (bvn <= 1.0) {
            return bvn;
        }
        return 1.0;
    }

    public double cdf(double x, double y) {
        return BiNormalDist.cdf((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho);
    }

    public static double cdf(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double X = (x - mu1) / sigma1;
        double Y = (y - mu2) / sigma2;
        return BiNormalDist.cdf(X, Y, rho);
    }

    public static double barF(double x, double y, double rho) {
        return BiNormalDist.cdf(-x, -y, rho);
    }

    public double barF(double x, double y) {
        return BiNormalDist.barF((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho);
    }

    public static double barF(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double X = (x - mu1) / sigma1;
        double Y = (y - mu2) / sigma2;
        return BiNormalDist.barF(X, Y, rho);
    }

    public double[] getMean() {
        return BiNormalDist.getMean(this.mu1, this.mu2, this.sigma1, this.sigma2, this.rho);
    }

    public static double[] getMean(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[] mean = new double[]{mu1, mu2};
        return mean;
    }

    public double[][] getCovariance() {
        return BiNormalDist.getCovariance(this.mu1, this.sigma1, this.mu2, this.sigma2, this.rho);
    }

    public static double[][] getCovariance(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] cov = new double[2][2];
        cov[0][0] = sigma1 * sigma1;
        cov[0][1] = rho * sigma1 * sigma2;
        cov[1][0] = cov[0][1];
        cov[1][1] = sigma2 * sigma2;
        return cov;
    }

    public double[][] getCorrelation() {
        return BiNormalDist.getCovariance(this.mu1, this.sigma1, this.mu2, this.sigma2, this.rho);
    }

    public static double[][] getCorrelation(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] corr = new double[2][2];
        corr[0][0] = 1.0;
        corr[0][1] = rho;
        corr[1][0] = rho;
        corr[1][1] = 1.0;
        return corr;
    }

    public double getMu1() {
        return this.mu1;
    }

    public double getMu2() {
        return this.mu2;
    }

    public double getSigma1() {
        return this.sigma1;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    protected void setParams(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(rho) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        this.dimension = 2;
        this.mu1 = mu1;
        this.sigma1 = sigma1;
        this.mu2 = mu2;
        this.sigma2 = sigma2;
        this.rho = rho;
        this.racRho = Math.sqrt((1.0 - rho) * (1.0 + rho));
        this.detS = Math.PI * 2 * sigma1 * sigma2 * this.racRho;
    }
}

