% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.r
\name{ggiNEXT3D}
\alias{ggiNEXT3D}
\title{ggplot2 extension for an iNEXT3D object}
\usage{
ggiNEXT3D(output, type = 1:3, facet.var = "Assemblage", color.var = "Order.q")
}
\arguments{
\item{output}{an \code{iNEXT3D} object computed by \code{iNEXT3D}.}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{facet.var}{create a separate plot for each value of a specified variable: 
no separation (\code{facet.var = "None"}); 
a separate plot for each diversity order (\code{facet.var = "Order.q"}); 
a separate plot for each assemblage (\code{facet.var = "Assemblage"}); 
a separate plot for each combination of diversity order and assemblage (\code{facet.var = "Both"}).}

\item{color.var}{create curves in different colors for values of a specified variable:
all curves are in the same color (\code{color.var = "None"}); 
use different colors for diversity orders (\code{color.var = "Order.q"}); 
use different colors for assemblages/sites (\code{color.var = "Assemblage"}); 
use different colors for combinations of diversity order and assemblage (\code{color.var = "Both"}).}
}
\value{
a \code{ggplot2} object for sample-size-based rarefaction/extrapolation curve (\code{type = 1}), sample completeness curve (\code{type = 2}), and coverage-based rarefaction/extrapolation curve (\code{type = 3}).
}
\description{
\code{ggiNEXT3D} is a \code{ggplot} extension for an \code{iNEXT3D} object to plot sample-size- and coverage-based rarefaction/extrapolation sampling curves along with a bridging sample completeness curve.
}
\examples{
\donttest{
# Plot three types of curves of taxonomic diversity with facet.var = "Assemblage"
# for abundance data with order q = 0, 1, 2
data(Brazil_rainforest_abun_data)
output_TD_abun <- iNEXT3D(Brazil_rainforest_abun_data, diversity = 'TD', q = c(0, 1, 2), 
                          datatype = "abundance")
ggiNEXT3D(output_TD_abun, facet.var = "Assemblage")


# Plot two types (1 and 3) of curves of phylogenetic diversity 
# for abundance data with order q = 0, 1, 2
data(Brazil_rainforest_abun_data)
data(Brazil_rainforest_phylo_tree)
data <- Brazil_rainforest_abun_data
tree <- Brazil_rainforest_phylo_tree
output_PD_abun <- iNEXT3D(data, diversity = 'PD', q = c(0, 1, 2), datatype = "abundance", 
                          nboot = 20, PDtree = tree)
ggiNEXT3D(output_PD_abun, type = c(1, 3))


# Plot three types of curves of functional diversity for abundance data
data(Brazil_rainforest_abun_data)
data(Brazil_rainforest_distance_matrix)
data <- Brazil_rainforest_abun_data
distM <- Brazil_rainforest_distance_matrix
output_FD_abun <- iNEXT3D(data, diversity = 'FD', datatype = "abundance", nboot = 0, 
                          FDdistM = distM, FDtype = 'AUC')
ggiNEXT3D(output_FD_abun)


# Plot three types of curves of taxonomic diversity for incidence data with order q = 0, 1, 2
data(Fish_incidence_data)
output_TD_inci <- iNEXT3D(Fish_incidence_data, diversity = 'TD', q = c(0, 1, 2), 
                          datatype = "incidence_raw")
ggiNEXT3D(output_TD_inci)


# Plot three types of curves of phylogenetic diversity with facet.var = "Order.q"
#  and color.var = "Assemblage" for incidence data with order q = 0, 1, 2
data(Fish_incidence_data)
data(Fish_phylo_tree)
data <- Fish_incidence_data
tree <- Fish_phylo_tree
output_PD_inci <- iNEXT3D(data, diversity = 'PD', q = c(0, 1, 2), datatype = "incidence_raw", 
                          nboot = 20, PDtree = tree)
ggiNEXT3D(output_PD_inci, facet.var = "Order.q", color.var = "Assemblage")


# Plot three types of curves of functional diversity for incidence data
data(Fish_incidence_data)
data(Fish_distance_matrix)
data <- Fish_incidence_data
distM <- Fish_distance_matrix
output_FD_inci <- iNEXT3D(data, diversity = 'FD', datatype = "incidence_raw", nboot = 20, 
                          FDdistM = distM, FDtype = 'AUC')
ggiNEXT3D(output_FD_inci)
}


}
