% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawplot.R
\name{plot.iNZightTS}
\alias{plot.iNZightTS}
\title{Draw a simple time series plot}
\usage{
\method{plot}{iNZightTS}(
  x,
  multiplicative = FALSE,
  ylab = obj$currVar,
  xlab = "Date",
  title = "\%var",
  animate = FALSE,
  t = 10,
  smoother = TRUE,
  aspect = 3,
  plot = TRUE,
  col = ifelse(forecast > 0, "#0e8c07", "red"),
  xlim = c(NA, NA),
  model.lim = NULL,
  forecast = 0,
  ...
)
}
\arguments{
\item{x}{an \code{iNZightTS} object}

\item{multiplicative}{logical. If \code{TRUE}, a multiplicative model is used,
otherwise an additive model is used by default.}

\item{ylab}{a title for the y axis}

\item{xlab}{a title for the x axis}

\item{title}{a title for the graph}

\item{animate}{logical, if true the graph is animated}

\item{t}{smoothing parameter}

\item{smoother}{logical, if \code{TRUE} the smoother will be drawn}

\item{aspect}{the aspect ratio of the plot;
it will be about ASPECT times wider than it is high}

\item{plot}{logical, if \code{FALSE}, the graph isn't drawn}

\item{col}{the colour of the smoothed trend line}

\item{xlim}{axis limits, specified as dates}

\item{model.lim}{limits of the series to use for modelling/forecast}

\item{forecast}{numeric, how many observations ahead to forecast (default is 0, no forecast)}

\item{...}{additional arguments (not used)}
}
\value{
a time series plot (constructed with ggplot2) is returned invisibly,
        which can be added to if desired.
}
\description{
Draws a plot of a given \code{iNZightTS} object with the trend superimposed.
}
\details{
If animate is set to \code{TRUE}, a scatterplot of all points in the
time series will appear followed by slowly drawn lines connecting the
points, simulating the drawing of a time series by hand.
}
\section{Forecast}{

The predictions and prediction intervals are the result of models
fitted by the Holt-Winters method. The amount of predicted
observations is specified by the value of `forecast`.
}

\examples{
t <- iNZightTS(visitorsQ)
plot(t)

# Forecast plot (8 quarterly forecasts):
plot(t, forecast = 8)

}
\references{
C.C Holt (1957)
Forecasting seasonals and trends by exponentially weighted
moving averages,
ONR Research Memorandum, Carnigie Institute 52.

P.R Winters (1960)
Forecasting sales by exponentially weighted moving averages,
\emph{Management Science} \bold{6}, 324--342.
}
\keyword{timeseries}
