% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_categorical.R
\name{missingToCat}
\alias{missingToCat}
\title{Convert missing values to categorical variables}
\usage{
missingToCat(.data, vars, names = paste0(vars, "_miss"))
}
\arguments{
\item{.data}{a dataframe with the columns to convert
its missing values into categorical}

\item{vars}{a character vector of the variables in \code{.data}
for conversion of missing values to categorical}

\item{names}{a vector of names for the new variables}
}
\value{
original dataframe containing new columns of the converted variables
       for the missing values
       with tidyverse code attached
}
\description{
Turn <NA>'s into a "missing" character;
hence numeric variables will be converted to categorical variables
with any numeric values will be converted to "observed",
and returns the result along with tidyverse code used to generate it.
}
\examples{
missing <- missingToCat(iris, vars = c("Species", "Sepal.Length"))
cat(code(missing))
head(missing)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
