% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_data.R
\name{aggregateData}
\alias{aggregateData}
\title{Aggregate data by categorical variables}
\usage{
aggregateData(.data, vars, summaries)
}
\arguments{
\item{.data}{a dataframe to aggregate}

\item{vars}{a character vector of categorical variables in \code{.data}
to group by}

\item{summaries}{summaries to generate for the groups generated
in \code{vars}.
Valid summaries are "iqr" , mean", "median", "sd", "sum"}
}
\value{
aggregated dataframe containing the summaries
        with tidyverse code attached
}
\description{
Aggregate a dataframe into summaries of all numeric variables by grouping
them by specified categorical variables
and returns the result along with tidyverse code used to generate it.
}
\examples{
aggregated <-
    aggregateData(iris,
        vars = c("Species"),
        summaries = c("mean", "sd", "iqr")
    )
cat(code(aggregated))
head(aggregated)

}
\seealso{
\code{\link{code}}

\code{\link{countMissing}}
}
\author{
Owen Jin
}
