% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{survey_IQR}
\alias{survey_IQR}
\title{Interquartile range function for surveys}
\usage{
survey_IQR(x, na.rm = TRUE)
}
\arguments{
\item{x}{A variable or expression}

\item{na.rm}{logical, if \code{TRUE} missing values are removed}
}
\value{
a vector of interquartile ranges
}
\description{
Calculates the interquartile range from complex survey data.
A wrapper for taking differences of \code{svyquantile} at 0.25 and 0.75 quantiles,
and meant to be called from within \code{summarize} (see \link{srvyr} package).
}
\examples{
library(survey)
library(srvyr)
data(api)

dstrata <- apistrat \%>\%
    as_survey(strata = stype, weights = pw)

dstrata \%>\%
    summarise(api99_iqr = survey_IQR(api99))

}
\author{
Tom Elliott
}
