% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_match_taxa_names.R
\name{ifcb_match_taxa_names}
\alias{ifcb_match_taxa_names}
\title{Retrieve WoRMS Records with Retry Mechanism}
\usage{
ifcb_match_taxa_names(
  taxa_names,
  best_match_only = TRUE,
  max_retries = 3,
  sleep_time = 10,
  marine_only = FALSE,
  return_list = FALSE,
  verbose = TRUE,
  fuzzy = deprecated()
)
}
\arguments{
\item{taxa_names}{A character vector of taxa names to retrieve records for.}

\item{best_match_only}{A logical value indicating whether to automatically select the first match and return a single match. Default is TRUE.}

\item{max_retries}{An integer specifying the maximum number of attempts to retrieve records.}

\item{sleep_time}{A numeric value indicating the number of seconds to wait between retry attempts.}

\item{marine_only}{Logical. If TRUE, restricts the search to marine taxa only. Default is FALSE.}

\item{return_list}{A logical value indicating whether to to return the output as a list. Default is FALSE, where the result is returned as a dataframe.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}

\item{fuzzy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
The fuzzy argument is no longer available}
}
\value{
A data frame (or list if return_list is TRUE) of WoRMS records or NULL if the retrieval fails after the maximum number of attempts.
}
\description{
This function attempts to retrieve WoRMS records using the provided taxa names.
It retries the operation if an error occurs, up to a specified number of attempts.
}
\examples{
\dontrun{
# Example: Retrieve WoRMS records for a list of taxa names
taxa <- c("Calanus finmarchicus", "Thalassiosira pseudonana", "Phaeodactylum tricornutum")
records <- ifcb_match_taxa_names(taxa_names = taxa,
                                 max_retries = 3,
                                 sleep_time = 5,
                                 marine_only = TRUE,
                                 verbose = TRUE)

print(records)
}

}
