% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.cca.R
\name{preview.cca}
\alias{preview.cca}
\title{Statistical description before using function iscca}
\usage{
preview.cca(x, y, L, scale.x = TRUE, scale.y = TRUE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}
}
\value{
An 'iscca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{loading.x:}{ the estimated canonical vector of variables x.}
\item{loading.y:}{ the estimated canonical vector of variables y.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
The function describes the basic statistical information of the data, including sample mean, sample co-variance of X and Y, and the first pair of canonical vector.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.cca")
x <- simData.cca$x
y <- simData.cca$y
L <- length(x)

prev_cca <- preview.cca(x = x, y = y, L = L, scale.x = TRUE, scale.y = TRUE)

}
\seealso{
See Also as \code{\link{iscca}}.
}
