% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{score.supervised_multi_learner}
\alias{score.supervised_multi_learner}
\title{Calculate the score for a multi-task model on the given data}
\usage{
\method{score}{supervised_multi_learner}(obj, X, ...)
}
\arguments{
\item{obj}{The learner or grid to evaluate.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.1/IAIBase/reference/#IAI.score-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BT\%7D\%7D\%20where\%20T\%3C\%3AIAIBase.SupervisedTask\%7D}{\code{IAI.score}}
and
\href{https://docs.interpretable.ai/v3.2.1/IAIBase/reference/#IAI.score-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BT\%7D\%7D\%20where\%20T\%3C\%3AIAIBase.SupervisedTask\%2C\%20Symbol\%7D}{\code{IAI.score}}
}
\section{IAI Compatibility}{

Requires IAI version 3.2 or higher.
}

\examples{
\dontrun{iai::score(lnr, X, y)}

}
