% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/throw_dice.R
\name{throw_dice}
\alias{throw_dice}
\title{Simulate Throws With One Or More Fair Dice}
\usage{
throw_dice(n, faces = 6L, dice = 1L)
}
\arguments{
\item{n}{number of throws. The value is cast to integer.}

\item{faces}{the number of faces of the dice. The value is cast to integer.}

\item{dice}{the number of dices to use for each throw. The value is
cast to integer.}
}
\value{
an integer vector of length \code{n} with the results of the throws.
}
\description{
Simulate throws with one or multiple fair dice with an arbitrary
number of faces.
}
\examples{
# throw a single 6-sided dice 5 times
throw_dice(5)

# throw a single 20-sided dice 7 times
throw_dice(7, faces = 20)

# throw two 6-sided dice 9 times
throw_dice(9, dice = 2)

}
