% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_functions.R
\name{ZeroTest}
\alias{ZeroTest}
\title{Zero-Inflation test for GLMM}
\usage{
ZeroTest(x)
}
\arguments{
\item{x}{An object of class \emph{GOF} generated by \emph{GOF_check} function.}
}
\value{
A vector with the zero count and the P-value.
}
\description{
Zero-Inflation test for GLMM
}
\details{
The function prints the count of zeros in the sample and the simulated P-value.
}
\examples{
\donttest{
# Poisson model. Repeatability setting.
iccpois<-icc_counts(EPP,y="Social",id="id")
iccpois.gof<-GOF_check(iccpois)
ZeroTest(iccpois.gof)
# Zero-inflated Poisson model. Repeatability setting
icczip<-icc_counts(EPP,y="Social",id="id",fam="zip")
icczip.gof<-GOF_check(icczip)
ZeroTest(icczip.gof)
}
}
\seealso{
\code{\link[=GOF_check]{GOF_check()}}
}
