% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{icd9LongToWide}
\alias{icd9LongToWide}
\alias{icd9WideToLong}
\title{Deprecated: convert ICD-9 patient data from long to wide format}
\usage{
icd9LongToWide(icd9df, visitId = get_visit_name(icd9df),
  icd9Field = get_icd_name(icd9df), prefix = "icd_", min.width = 0,
  aggregate = TRUE, return.df = FALSE)

icd9WideToLong(x, visitId = get_visit_name(x), icdLabels = NULL,
  icdName = "icdCode", icdRegex = c("icd", "diag", "dx_", "dx"),
  verbose = FALSE)
}
\arguments{
\item{icd9df}{\code{data.frame} of long-form data, one column for
\code{visitId} and one for ICD code}

\item{visitId}{Deprecated. Use \code{visit_name}}

\item{icd9Field}{The column in the data frame which contains the ICD codes.
This is a character vector of length one. If it is \code{NULL}, \code{icd9}
will attempt to guess the column name, looking for progressively less
likely possibilities until it matches a single column. Failing this, it
will take the first column in the data frame. Specifying the column using
this argument avoids the guesswork.}

\item{prefix}{character}

\item{min.width, }{single integer, if specified, writes out this many columns
even if no patients have that many codes. Must be greater than or equal to
the maximum number of codes per patient.}

\item{aggregate}{single logical value, if \code{TRUE} (the default) will take more
time to find out-of-order \code{visitId}s, and combine all the codes for
each unique \code{visitId}. If \code{FALSE}, then out-of-order
\code{visitId}s will result in a row in the output data per contiguous
block of identical \code{visitId}s.}

\item{return.df}{single logical value, if \code{TRUE}, return a data frame
with a field for the \code{visitId}. This may be more convenient, but the
default of \code{FALSE} gives the more natural return data of a matrix with
row names being the \code{visitId}s.}

\item{x}{wide format data}

\item{icdLabels}{Deprecated. Character vector of column names in which codes
are found. If \code{NULL}, all columns matching \code{icdRegex} will be included.}

\item{icdName}{Deprecated. Character vector length one containing the new
column name for the ICD codes, defaults to \code{"icdCode"}}

\item{icdRegex}{Deprecated. Vector of character strings containing a regular
expression to identify ICD-9 diagnosis columns to try (case-insensitive) in
order. Default is \code{c("icd", "diag", "dx_", "dx")}}

\item{verbose}{single logical value, defaults to \code{FALSE} in most functions.}
}
\description{
Use \code{icd_long_to_wide} or \code{icd_wide_to_long} instead.
}

