% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort_icd}
\alias{sort_icd}
\alias{sort.icd10}
\alias{sort.icd10cm}
\alias{sort.icd10be}
\alias{sort.icd9}
\alias{order.icd9}
\alias{order.icd10cm}
\alias{order.icd10be}
\title{Sort or order ICD-9 or ICD-10 codes according to published sequence}
\usage{
sort_icd(x, decreasing = FALSE, short_code = guess_short(x), ...)

\method{sort}{icd10}(x, decreasing = FALSE, ...)

\method{sort}{icd10cm}(x, decreasing = FALSE, ...)

\method{sort}{icd10be}(x, decreasing = FALSE, ...)

\method{sort}{icd9}(x, decreasing = FALSE, short_code = guess_short(x),
  ...)

order.icd9(x, na.last = TRUE)

order.icd10cm(x)

order.icd10be(x)
}
\arguments{
\item{x}{vector of ICD codes to sort or order}

\item{decreasing}{Logical See \code{\link[base]{sort}}.}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{na.last}{Logical, analogous to \code{order}, so \code{NA} drops NA.
\code{FALSE} is not currently supported.}
}
\value{
For sort, a sorted vector of ICD-9 codes. Numeric, then E codes, then
  V codes. For order, an integer vector is returned with the order of each
  code.
}
\description{
The default method will guess whether ICD-9 or ICD-10  then sort
  based on that type. For ICD-10 codes, note that setting \code{short} is
  unnecessary and ignored. All codes should consistently use the decimal
  divider.
}
\details{
Note that \code{\link[base]{sort}} is an S3 generic, whereas
  \code{\link[base]{order}} is not. Thus we export \code{order.icd10cm}, but
  not \code{sort.icd10cm}, etc..
}
\section{ICD-9}{
 Sorts lists of numeric, V or E codes. Note that a simple
  numeric sort does not work for ICD-9 codes, since \code{162 > 1620}, and
  also \sQuote{V} codes precede \sQuote{E} codes. Numeric codes are first,
  then \sQuote{V}, then \sQuote{E}. A factor is returned if a factor is
  given.
}

\section{ICD-10-CM and ICD-10-BE}{
 There are some codes which are sequenced
  out of lexicographic order, e.g., \code{C7A} and \code{C7B} are between
  \code{C80} and \code{C81}; \code{D3A} is between \code{D48} and \code{D49}.
}

\examples{
# order ICD-10-CM is not lexicographic:
codes <- as.icd10cm(c("C7A", "C79", "C80", "C81", "C7B"))
# as the class is set, use S3 dispatch to get the right answer
sort(codes)
# or call directly, but recall S3 dispatch will only work once 'icd' is
# attached using:
library(icd)
icd:::sort.icd10cm(c("C7A", "C79", "C80", "C81", "C7B"))
stopifnot(!identical(
  order.icd10cm(as.character(codes)),
  order(codes)
))
icd::order.icd9(c("V20", NA, "100", NA, "E998", "101"))
codes[order.icd10cm(codes)]
# Note that base::order does NOT do S3 dispatch, so the following does not work:
codes[order(codes)]
}
\keyword{manip}
