% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9SortShort}
\alias{icd9SortShort}
\title{sort short-form icd9 codes}
\usage{
icd9SortShort(icd9Short, invalidAction = c("ignore", "silent", "warn",
  "stop"))
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
sorted vector of ICD-9 codes
}
\description{
should work with numeric only, V or E codes. Note that a numeric
  sort does not work for ICD-9 codes, since "162" > "1620" TODO: write tests.
  TODO: reply with the actual items given (not trimmed, etc.) TODO: need to
  be able to compare a pair of codes quickly, then use built-in sort. This
  becomes easier when I move to S3 classes for ICD-9.
}
\keyword{manip}

