% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/valid.R
\name{icd9IsValidMapping}
\alias{icd9GetInvalidMappingDecimal}
\alias{icd9GetInvalidMappingShort}
\alias{icd9IsValidMapping}
\alias{icd9IsValidMappingDecimal}
\alias{icd9IsValidMappingShort}
\title{validate an icd9 mapping to comorbidities}
\usage{
icd9IsValidMapping(icd9Mapping, isShort)

icd9IsValidMappingShort(icd9Mapping)

icd9IsValidMappingDecimal(icd9Mapping)

icd9GetInvalidMappingShort(icd9Mapping)

icd9GetInvalidMappingDecimal(icd9Mapping)
}
\arguments{
\item{icd9Mapping}{named list containing vectors of icd9 codes. E.g. the AHRQ
comorbidities, contains \code{list(OBESE = c("2780", "27800", "27801",
"27803", "V8554", "79391", "64910", "64911", "64912", "64913", "64914",
"V8530", "V8531", "V8532", "V8533", "V8534", "V8535", "V8536", "V8537",
"V8538", "V8539", "V8541", "V8542", "V8543", "V8544", "V8545" ), DEPRESS =
c("3004", "30112", "3090", "3091", "311"))} amongst other longer groups.}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}
}
\description{
takes each item in each vector of the list of vectors and checks
  validity, or returns those items which are valid for each comorbidity.
}
\seealso{
Other ICD9 validation: \code{\link{icd9IsValid}},
  \code{\link{icd9IsValidDecimal}},
  \code{\link{icd9IsValidMajor}},
  \code{\link{icd9IsValidShort}},
  \code{\link{icd9IsValidShortE}},
  \code{\link{icd9IsValidShortN}},
  \code{\link{icd9IsValidShortV}}, \code{\link{icd9Valid}},
  \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidShort}}
}

