% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHLdata.R
\name{getHLdata}
\alias{getHLdata}
\title{Get Length-Based Data}
\usage{
getHLdata(survey, year, quarter)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data frame.
}
\description{
Get length-based information such as measured length, individual counts,
  and sub-factors of sampled species.
}
\examples{
\dontrun{
hldata <- getHLdata(survey = "ROCKALL", year = 2002, quarter = 3)
str(hldata)
}
}
\seealso{
\code{\link{getDATRAS}} supports querying many years and quarters in one function call.

\code{\link{getHHdata}} and \code{\link{getCAdata}} get haul data and
age-based data.

\code{\link{icesDatras-package}} gives an overview of the package.
}
