% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStockDownloadData.R
\name{getStockSourceData}
\alias{getStockSourceData}
\alias{getStockDownloadData}
\title{Get Source Data}
\usage{
getStockDownloadData(assessmentKey, ...)

getStockSourceData(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{to allow scope for back compatibility}
}
\value{
A data frame.
}
\description{
Get a copy of the source data for the specified stocks.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("cod-2224", year = 2016)
sourcedat <- getStockDownloadData(assessmentKey)
head(sourcedat[[1]])
}

}
\seealso{
\code{\link{getSAG}} supports querying many years in one function call.

\code{\link{getListStocks}} and \code{\link{getFishStockReferencePoints}} get
  a list of stocks and reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
