% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{ichimoku}
\alias{ichimoku}
\alias{ichimoku.ichimoku}
\alias{ichimoku.xts}
\alias{ichimoku.matrix}
\alias{ichimoku.data.frame}
\alias{ichimoku.default}
\title{ichimoku}
\usage{
ichimoku(x, ...)

\method{ichimoku}{ichimoku}(x, ticker, ...)

\method{ichimoku}{xts}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{matrix}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{data.frame}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{default}(x = NULL, ticker, ...)
}
\arguments{
\item{x}{a data.frame or other compatible object, which includes xts,
data.table, tibble, and matrix.}

\item{...}{other arguments to be passed along.}

\item{ticker}{(optional) specify a ticker to identify the instrument,
otherwise this will be set to the name of the input object 'x'.}

\item{periods}{a vector defining the length of periods used for the cloud,
with a default of c(9, 26, 52). This parameter shoud not normally be
changed as using other values would be invalid in the context of
traditional Ichimoku analysis.}
}
\value{
An ichimoku object is returned with S3 classes of 'ichimoku' and
    'data.frame'.

    This object contains a date-time index, OHLC pricing data, candlestick
    direction, as well as the computed ichimoku cloud values, with ticker and
    periodicity parameters set as attributes.
}
\description{
Create an ichimoku object containing the values for all components of the
    Ichimoku Kinko Hyo cloud chart, ready for plotting. The object includes
    the candlesticks as well as the computed cloud lines: Tenkan-sen,
    Kijun-sen, Senkou span A, Senkou span B and Chikou span.
}
\details{
Calling an ichimoku object automatically invokes its print method,
    which in the absence of arguments, will produce a printout of the data to
    the console as well as a static plot of the cloud chart to the graphical
    device.

    For further options, including interactive charting, use plot() on the
    returned ichimoku object to pass further arguments for customising
    the chart.

    Where an ichimoku object is passed to ichimoku(), the original object
    will be returned (with the ticker amended if the corresponding parameter
    is set).
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data)
ichimoku(sample_ohlc_data, ticker = "TKR", periods = c(9, 26, 52))

}
