## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7, fig.height = 5
)
library(httptest)
start_vignette("oanda")

## ----oanda--------------------------------------------------------------------
library(ichimoku)
oanda("USD_JPY", count = 3, from = "2010-11-01", price = "B", apikey = NULL)

## ----instruments, echo=FALSE--------------------------------------------------
data.frame(
               stringsAsFactors = FALSE,
  name.....type.....displayName = c("AU200_AUD      CFD   Australia 200",
                                    "AUD_CAD CURRENCY         AUD/CAD",
                                    "AUD_CHF CURRENCY         AUD/CHF",
                                    "AUD_HKD CURRENCY         AUD/HKD","AUD_JPY CURRENCY         AUD/JPY",
                                    "AUD_NZD CURRENCY         AUD/NZD",
                                    "AUD_SGD CURRENCY         AUD/SGD",
                                    "AUD_USD CURRENCY         AUD/USD",
                                    "BCO_USD      CFD Brent Crude Oil",
                                    "CAD_CHF CURRENCY         CAD/CHF","CAD_HKD CURRENCY         CAD/HKD",
                                    "CAD_JPY CURRENCY         CAD/JPY",
                                    "CAD_SGD CURRENCY         CAD/SGD",
                                    "CHF_HKD CURRENCY         CHF/HKD",
                                    "CHF_JPY CURRENCY         CHF/JPY","CHF_ZAR CURRENCY         CHF/ZAR",
                                    "CN50_USD      CFD       China A50",
                                    "CORN_USD      CFD            Corn",
                                    "DE10YB_EUR      CFD            Bund",
                                    "DE30_EUR      CFD      Germany 30",
                                    "EU50_EUR      CFD       Europe 50",
                                    "EUR_AUD CURRENCY         EUR/AUD","EUR_CAD CURRENCY         EUR/CAD",
                                    "EUR_CHF CURRENCY         EUR/CHF",
                                    "EUR_CZK CURRENCY         EUR/CZK",
                                    "EUR_DKK CURRENCY         EUR/DKK",
                                    "EUR_GBP CURRENCY         EUR/GBP","EUR_HKD CURRENCY         EUR/HKD",
                                    "EUR_HUF CURRENCY         EUR/HUF",
                                    "EUR_JPY CURRENCY         EUR/JPY",
                                    "EUR_NOK CURRENCY         EUR/NOK",
                                    "EUR_NZD CURRENCY         EUR/NZD",
                                    "EUR_PLN CURRENCY         EUR/PLN","EUR_SEK CURRENCY         EUR/SEK",
                                    "EUR_SGD CURRENCY         EUR/SGD",
                                    "EUR_TRY CURRENCY         EUR/TRY",
                                    "EUR_USD CURRENCY         EUR/USD",
                                    "EUR_ZAR CURRENCY         EUR/ZAR","FR40_EUR      CFD       France 40",
                                    "GBP_AUD CURRENCY         GBP/AUD",
                                    "GBP_CAD CURRENCY         GBP/CAD",
                                    "GBP_CHF CURRENCY         GBP/CHF",
                                    "GBP_HKD CURRENCY         GBP/HKD",
                                    "GBP_JPY CURRENCY         GBP/JPY","GBP_NZD CURRENCY         GBP/NZD",
                                    "GBP_PLN CURRENCY         GBP/PLN",
                                    "GBP_SGD CURRENCY         GBP/SGD",
                                    "GBP_USD CURRENCY         GBP/USD",
                                    "GBP_ZAR CURRENCY         GBP/ZAR","HK33_HKD      CFD    Hong Kong 33",
                                    "HKD_JPY CURRENCY         HKD/JPY",
                                    "IN50_USD      CFD        India 50",
                                    "JP225_USD      CFD       Japan 225",
                                    "NAS100_USD      CFD      US Nas 100",
                                    "NATGAS_USD      CFD     Natural Gas",
                                    "NL25_EUR      CFD  Netherlands 25","NZD_CAD CURRENCY         NZD/CAD",
                                    "NZD_CHF CURRENCY         NZD/CHF",
                                    "NZD_HKD CURRENCY         NZD/HKD",
                                    "NZD_JPY CURRENCY         NZD/JPY",
                                    "NZD_SGD CURRENCY         NZD/SGD",
                                    "NZD_USD CURRENCY         NZD/USD","SG30_SGD      CFD    Singapore 30",
                                    "SGD_CHF CURRENCY         SGD/CHF",
                                    "SGD_JPY CURRENCY         SGD/JPY",
                                    "SOYBN_USD      CFD        Soybeans",
                                    "SPX500_USD      CFD      US SPX 500",
                                    "SUGAR_USD      CFD           Sugar","TRY_JPY CURRENCY         TRY/JPY",
                                    "TWIX_USD      CFD    Taiwan Index",
                                    "UK100_GBP      CFD          UK 100",
                                    "UK10YB_GBP      CFD     UK 10Y Gilt",
                                    "US2000_USD      CFD    US Russ 2000",
                                    "US30_USD      CFD   US Wall St 30",
                                    "USB02Y_USD      CFD    US 2Y T-Note",
                                    "USB05Y_USD      CFD    US 5Y T-Note","USB10Y_USD      CFD   US 10Y T-Note",
                                    "USB30Y_USD      CFD       US T-Bond",
                                    "USD_CAD CURRENCY         USD/CAD",
                                    "USD_CHF CURRENCY         USD/CHF",
                                    "USD_CNH CURRENCY         USD/CNH",
                                    "USD_CZK CURRENCY         USD/CZK","USD_DKK CURRENCY         USD/DKK",
                                    "USD_HKD CURRENCY         USD/HKD",
                                    "USD_HUF CURRENCY         USD/HUF",
                                    "USD_INR CURRENCY         USD/INR",
                                    "USD_JPY CURRENCY         USD/JPY","USD_MXN CURRENCY         USD/MXN",
                                    "USD_NOK CURRENCY         USD/NOK",
                                    "USD_PLN CURRENCY         USD/PLN",
                                    "USD_SEK CURRENCY         USD/SEK",
                                    "USD_SGD CURRENCY         USD/SGD",
                                    "USD_THB CURRENCY         USD/THB","USD_TRY CURRENCY         USD/TRY",
                                    "USD_ZAR CURRENCY         USD/ZAR",
                                    "WHEAT_USD      CFD           Wheat",
                                    "WTICO_USD      CFD  West Texas Oil",
                                    "XAG_AUD    METAL      Silver/AUD",
                                    "XAG_CAD    METAL      Silver/CAD","XAG_CHF    METAL      Silver/CHF",
                                    "XAG_EUR    METAL      Silver/EUR",
                                    "XAG_GBP    METAL      Silver/GBP",
                                    "XAG_HKD    METAL      Silver/HKD",
                                    "XAG_JPY    METAL      Silver/JPY","XAG_NZD    METAL      Silver/NZD",
                                    "XAG_SGD    METAL      Silver/SGD",
                                    "XAG_USD    METAL          Silver",
                                    "XAU_AUD    METAL        Gold/AUD",
                                    "XAU_CAD    METAL        Gold/CAD",
                                    "XAU_CHF    METAL        Gold/CHF","XAU_EUR    METAL        Gold/EUR",
                                    "XAU_GBP    METAL        Gold/GBP",
                                    "XAU_HKD    METAL        Gold/HKD",
                                    "XAU_JPY    METAL        Gold/JPY",
                                    "XAU_NZD    METAL        Gold/NZD","XAU_SGD    METAL        Gold/SGD",
                                    "XAU_USD    METAL            Gold",
                                    "XAU_XAG    METAL     Gold/Silver",
                                    "XCU_USD      CFD          Copper",
                                    "XPD_USD    METAL       Palladium",
                                    "XPT_USD    METAL        Platinum","ZAR_JPY CURRENCY         ZAR/JPY")
)

## ---- include=FALSE-----------------------------------------------------------
end_vignette()

