% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{summary.ichimoku}
\alias{summary.ichimoku}
\title{Summary of Ichimoku Strategies}
\usage{
\method{summary}{ichimoku}(object, strat = TRUE, ...)
}
\arguments{
\item{object}{an object of class 'ichimoku'.}

\item{strat}{[default TRUE] to show the strategy summary if present. Set to
FALSE to show the data summary instead.}

\item{...}{additional arguments to be passed along.}
}
\value{
A matrix containing the strategy summary if present, otherwise a table
    containing the data summary.
}
\description{
Custom summary method for ichimoku objects for viewing strategies.
}
\details{
This function is an S3 method for the generic function summary() for
    class 'ichimoku'. It can be invoked by calling summary(x) on an object 'x'
    of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the strategies vignette by running:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
strat <- strat(ichimoku(sample_ohlc_data, ticker = "TKR"))
summary(strat)

}
