% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTree.R
\name{getTree.icrf}
\alias{getTree.icrf}
\alias{getTree}
\title{Extract a single tree from an icrf object}
\usage{
getTree(x, ...)

\method{getTree}{icrf}(x, k = 1, labelVar = FALSE, ...)
}
\arguments{
\item{x}{an \code{icrf} object.}

\item{...}{not used.}

\item{k}{'which tree to extract?'}

\item{labelVar}{Splitting variables will be labelled with the original names
when \code{labelVar = TRUE}. Otherwise they will be expressed as integers.}
}
\value{
'A matrix (or data frame, if labelVar=TRUE) with' (5 + number of time points) 'columns and
number of rows equal to total number of nodes in the tree. The columns are:'
 \itemize{
  \item{left daughter:}{ 'the row where the left daughter node is; 0 if the node is terminal'}
  \item{right daughter:}{ 'the row where the right daughter node is; 0 if the node is terminal'}
  \item{split var:}{ 'which variable was used to split the node; 0 if the node is terminal'}
  \item{split point:}{ 'where the best split is; see Details for categorical predictor'}
  \item{status:}{ 'is the node terminal' (-1) or not (-3)}
  \item{from the 6th to the last columns:}{ the survival probability prediction for the node;
  each column represents the distinct time points.
  '0 if the node is not terminal'}
 }
}
\description{
\code{getTree} 'extracts the structure of a tree from an \code{icrf} object.'
Among \code{nfold} forests, the forest designated when implementing \code{icrf} will be
considered. i.e., the \code{k}th tree of the last forest, when \code{returnBest = FALSE} or
the tree of the best forest, when \code{returnBest = TRUE}, will be extracted.
(Quoted statements are from \code{randomForest} by Liaw and Wiener unless otherwise mentioned.)
}
\details{
'For numerical predictors, data with values of the variable less than or equal
to the splitting point go to the left daughter node.'

'For categorical predictors, the splitting point is represented by an integer,
whose binary expansion gives the identities of the categories that goes to left or right.
For example, if a predictor has four categories, and the split point is 13.
The binary expansion of 13 is (1, 0, 1, 1) (because 13 = 1*2^0 + 0*2^1 + 1*2^2 + 1*2^3),
so cases with categories 1, 3, or 4 in this predictor get sent to the left,
and the rest to the right.'
}
\examples{
library(survival) # for Surv()
data(rat2)
L = ifelse(rat2$tumor, 0, rat2$survtime)
R = ifelse(rat2$tumor, rat2$survtime, Inf)
# Note that this is a toy example. Use a larger ntree and nfold in practice.
\donttest{
set.seed(1)
rats.icrf <-
  icrf(Surv(L, R, type = "interval2") ~ dose.lvl + weight + male + cage.no,
       data = rat2, ntree = 10, nfold = 3)
getTree(rats.icrf, k = 2)
}
\dontshow{
set.seed(2)
rats.icrf <-
  icrf(Surv(L, R, type = "interval2") ~ dose.lvl + weight + male + cage.no,
       data = rat2, ntree = 2, nfold = 2)
getTree(rats.icrf, k = 2)
}


}
