% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fauxmesa_edges}
\alias{fauxmesa_edges}
\title{Goodreau's Faux Mesa High School (Edgelist)}
\format{
A data frame with 203 rows and 2 columns:
\describe{
  \item{from}{Outgoing node}
  \item{to}{Receiving node}
  ...
}
}
\source{
The data set is based upon a model fit to data from one school
community from the AddHealth Study, Wave I (Resnick et al., 1997). It was
constructed as follows:

A vector representing the sex of each student in the school was randomly
re-ordered.  The same was done with the students' response to questions on
race and grade.  These three attribute vectors were permuted independently.
Missing values for each were randomly assigned with weights determined by
the size of the attribute classes in the school.

The following \code{ergm} formula was used to fit a model to the
original data:

\preformatted{ ~ edges + nodefactor("Grade") + nodefactor("Race") +
nodefactor("Sex") + nodematch("Grade",diff=TRUE) +
nodematch("Race",diff=TRUE) + nodematch("Sex",diff=FALSE) +
gwdegree(1.0,fixed=TRUE) + gwesp(1.0,fixed=TRUE) + gwdsp(1.0,fixed=TRUE) }

The resulting model fit was then applied to a network with actors possessing
the permuted attributes and with the same number of edges as in the original
data.

The processes for handling missing data and defining the race attribute are
described in Hunter, Goodreau & Handcock (2008).
}
\usage{
fauxmesa_edges
}
\description{
This data set (originally found in as a \code{network} object in the \code{ergm} package)
represents a simulation of an in-school friendship network. The network is named "Faux Mesa High" because the school
community on which it is based is in the rural western US, with a student body that is largely Hispanic and Native American.
}
\keyword{datasets}
