% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_algorithms.R
\name{SeqDB}
\alias{SeqDB}
\title{Sequential modified federov algorithm for MNL model.}
\usage{
SeqDB(des, cand.set, n.alts, par.draws, prior.covar, reduce = TRUE,
  weights = NULL)
}
\arguments{
\item{des}{A design matrix in which each row is a profile. Can be generated
with \code{\link{Modfed}}}

\item{cand.set}{A numeric matrix in which each row is a possible profile. The
\code{\link{Profiles}} function can be used to generate this.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{par.draws}{A matrix in which each row is a sample from the
multivariate parameter distribution. See also \code{\link{ImpsampMNL}}.}

\item{prior.covar}{Covariance matrix of the prior distribution.}

\item{reduce}{Logical value indicating whether the candidate set should be
reduced or not.}

\item{weights}{A vector containing the weights of the samples. Default is
\code{NULL}, See also \code{\link{ImpsampMNL}}.}
}
\value{
\item{set}{A matrix representing a DB efficient choice set.}
\item{db.error}{A numeric value indicating the DB-error of the whole design.}
}
\description{
Selects the choice set that minimizes the DB-error when added to an initial
design, given (updated) parameter values.
}
\details{
This algorithm is ideally used in an adaptive context. The algorithm will
select the next DB-efficient choice set given parameter values and an initial
design. In an adaptive context these parameter values are updated after each
observed response.

The initial design \code{des} can be generated with \code{\link{Modfed}}. If
alternative specific constants are included in the initial design, the
algorithm will use the same for selecting the new choice set. Columns of
\code{des} which contain ".cte" in their name are recognized as alternative
specific columns.

The list of potential choice sets are created using
\code{\link[gtools]{combinations}}. If \code{reduce} is \code{TRUE},
\code{repeats.allowed = FALSE} and vice versa. If no alternative constants
are used \code{reduce} should always be \code{TRUE}. When alternative
specific constants are used \code{reduce} can be \code{TRUE} so that the
algorithm will be faster, but the combinations of constants and profiles will
not be evaluated exhaustively.

The \code{weights} can be used when the \code{par.draws} have weights. This
is for example the case when parameter values are updated using
\code{\link{ImpsampMNL}}.
}
\examples{
# DB efficient choice set, given a design and parameter samples. 
# Candidate profiles 
cs <- Profiles(lvls = c(3, 3), coding = c("E", "E"))
m <- c(0.3, 0.2, -0.3, -0.2) # Prior mean (total = 5 parameters).
pc <- diag(length(m)) # Prior variance
set.seed(123)
ps <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc) # 10 Samples.
ac <- c(0, 0) # No alternative specific constants. 
# Initial design.
des <- Modfed(cand.set = cs, n.sets = 6, n.alts = 2, alt.cte = ac, par.draws = ps)$design
# Efficient choice set to add. 
SeqDB(des = des, cand.set = cs, n.alts = 2, par.draws = ps, prior.covar = pc)

# DB efficient choice set, given a design and parameter samples. 
# Candidate profiles 
cs <- Profiles(lvls = c(3, 3), coding = c("C", "E"), c.lvls = list(c(5,3,1)))
m <- c(0.7, 0.3, -0.3, -0.2) # Prior mean (4 parameters).
pc <- diag(length(m)) # Prior variance
set.seed(123)
ps <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc) # 10 Samples.
ac <- c(1, 0) # Alternative specific constant. 
# Initial design.
des <- Modfed(cand.set = cs, n.sets = 6, n.alts = 2, alt.cte = ac, par.draws = ps)$design
# Efficient choice set to add. 
SeqDB(des = des, cand.set = cs, n.alts = 2, par.draws = ps, prior.covar = pc)
}
\references{
\insertRef{ju}{mnldes}
}
