% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idmodelr.R
\docType{package}
\name{idmodelr-package}
\alias{idmodelr}
\alias{idmodelr-package}
\title{idmodelr: Infectious Disease Model Library and Utilities}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Explore a range of infectious disease models in a consistent framework. 
    The primary aim of 'idmodelr' is to provide a library of infectious disease models
    for researchers, students, and other interested individuals. These models can be 
    used to understand the underlying dynamics and as a reference point when developing
    models for research. 'idmodelr' also provides a range of utilities. These include: plotting 
    functionality; a simulation wrapper; scenario analysis tooling; an interactive 
    dashboard; tools for handling mult-dimensional models; and both model and parameter
    look up tables. Unlike other modelling packages such as 'pomp' (<https://kingaa.github.io/pomp/>), 'libbi' (<http://libbi.org>)
    and 'EpiModel' (<http://www.epimodel.org>), 'idmodelr' serves primarily as an educational 
    resource. It is most comparable to epirecipes (<http://epirecip.es/epicookbook/chapters/simple>)
    but provides a more consistent framework, an R based workflow, and additional utility tooling. 
    After users have explored model dynamics with 'idmodelr' they may then 
    implement their model using one of these packages in order to utilise the model
    fitting tools they provide.  For newer modellers, this package reduces the barrier
    to entry by containing multiple infectious disease models, providing a consistent
    framework for simulation and visualisation, and signposting towards other, more 
    research focussed, resources.
}
\seealso{
Useful links:
\itemize{
  \item \url{http://www.samabbott.co.uk/idmodelr}
  \item \url{https://github.com/seabbs/idmodelr}
  \item Report bugs at \url{https://github.com/seabbs/idmodelr/issues}
}

}
\author{
\strong{Maintainer}: Sam Abbott \email{contact@samabbott.co.uk} (\href{https://orcid.org/0000-0001-8057-8037}{ORCID})

Authors:
\itemize{
  \item Akira Endo \email{akira.endo@lshtm.ac.uk} (\href{https://orcid.org/0000-0001-6377-7296}{ORCID})
}

}
\keyword{internal}
