% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld_clump.R
\name{ld_clump_api}
\alias{ld_clump_api}
\title{Perform clumping on the chosen variants using through API}
\usage{
ld_clump_api(
  dat,
  clump_kb = 10000,
  clump_r2 = 0.1,
  clump_p,
  pop = "EUR",
  access_token = check_access_token()
)
}
\arguments{
\item{dat}{Dataframe. Must have a variant name column (\code{variant}) and pval column called \code{pval}.
If \code{id} is present then clumping will be done per unique id.}

\item{clump_kb}{Clumping kb window. Default is very strict, \code{10000}}

\item{clump_r2}{Clumping r2 threshold. Default is very strict, \code{0.001}}

\item{clump_p}{Clumping sig level for index variants. Default = \code{1} (i.e. no threshold)}

\item{pop}{Super-population to use as reference panel. Default = \code{"EUR"}.
Options are \code{"EUR"}, \code{"SAS"}, \code{"EAS"}, \code{"AFR"}, \code{"AMR"}}

\item{access_token}{Google OAuth2 access token. Used to authenticate level of access to data}
}
\value{
Data frame of only independent variants
}
\description{
Perform clumping on the chosen variants using through API
}
