% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_meals.R
\name{plot_meals}
\alias{plot_meals}
\title{Plot meal metrics visualization}
\usage{
plot_meals(data, mealtimes, plot_type=c('ggplot','plotly'))
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, a warning is produced and only 1st subject is used.}

\item{mealtimes}{Either a vector of mealtimes, corresponding
to data being from a single subject, OR a dataframe with at least 2 columns labeled
id and mealtime. Optionally the mealtimes dataframe can include a column labeled meal,
giving the meal type (helps to compensate for overlapping meals)}

\item{plot_type}{Default: "ggplot". One of 'ggplot', 'plotly'. Determines whether the function returns a static publication-ready image or an interactive GUI.}
}
\value{
Plot to visualize meals data.
}
\description{
The function plot_meals produces a visual for meals data
}
\details{
Only a single subject's data may be plotted. The solid black line is the glucose trace.
Vertical dashed red lines show the mealtimes, and the horizontal blue lines
show the baseline for each meal. Purple triangles are plotted to illustrate the 3 meal_metrics
Namely the three vertices show the baseline, peak, and 1hr post-peak recovery. If
plot_type = 'plotly', plotly is used to display an interactive visual that allows
one to zoom into specific areas of the plot.
}
\examples{

select_subject = example_data_hall[example_data_hall$id == "2133-018", ]
select_meals = example_meals_hall[example_meals_hall$id == "2133-018", ]
plot_meals(select_subject, select_meals)
}
\references{
Service, F. John. (2013) Glucose Variability, \emph{Diabetes}
\strong{62(5)}: 1398-1404, \doi{10.2337/db12-1396}
}
\seealso{
meal_metrics()
}
\author{
Elizabeth Chun
}
