% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_drl.R
\name{layout_with_drl}
\alias{layout_with_drl}
\alias{layout.drl}
\alias{drl_defaults}
\alias{igraph.drl.coarsen}
\alias{igraph.drl.coarsest}
\alias{igraph.drl.default}
\alias{igraph.drl.final}
\alias{igraph.drl.refine}
\alias{with_drl}
\title{The DrL graph layout generator}
\usage{
layout_with_drl(
  graph,
  use.seed = FALSE,
  seed = matrix(runif(vcount(graph) * 2), ncol = 2),
  options = drl_defaults$default,
  weights = NULL,
  fixed = NULL,
  dim = 2
)

with_drl(...)
}
\arguments{
\item{graph}{The input graph, in can be directed or undirected.}

\item{use.seed}{Logical scalar, whether to use the coordinates given in the
\code{seed} argument as a starting point.}

\item{seed}{A matrix with two columns, the starting coordinates for the
vertices is \code{use.seed} is \code{TRUE}. It is ignored otherwise.}

\item{options}{Options for the layout generator, a named list. See details
below.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for the layout. Larger edge weights
correspond to stronger connections.}

\item{fixed}{Logical vector, it can be used to fix some vertices. Unfortunately
this has never been implemented in the C core of the igraph library and thus
it never worked. The argument is now deprecated and will be removed in
igraph 1.4.0.}

\item{dim}{Either \sQuote{2} or \sQuote{3}, it specifies whether we want a
two dimensional or a three dimensional layout. Note that because of the
nature of the DrL algorithm, the three dimensional layout takes
significantly longer to compute.}

\item{...}{Passed to \code{layout_with_drl()}.}
}
\value{
A numeric matrix with two columns.
}
\description{
DrL is a force-directed graph layout toolbox focused on real-world
large-scale graphs, developed by Shawn Martin and colleagues at Sandia
National Laboratories.
}
\details{
This function implements the force-directed DrL layout generator.

The generator has the following parameters: \describe{ \item{edge.cut}{Edge
cutting is done in the late stages of the algorithm in order to achieve less
dense layouts.  Edges are cut if there is a lot of stress on them (a large
value in the objective function sum). The edge cutting parameter is a value
between 0 and 1 with 0 representing no edge cutting and 1 representing
maximal edge cutting. } \item{init.iterations}{Number of iterations in the
first phase.} \item{init.temperature}{Start temperature, first phase.}
\item{init.attraction}{Attraction, first phase.}
\item{init.damping.mult}{Damping, first phase.}
\item{liquid.iterations}{Number of iterations, liquid phase.}
\item{liquid.temperature}{Start temperature, liquid phase.}
\item{liquid.attraction}{Attraction, liquid phase.}
\item{liquid.damping.mult}{Damping, liquid phase.}
\item{expansion.iterations}{Number of iterations, expansion phase.}
\item{expansion.temperature}{Start temperature, expansion phase.}
\item{expansion.attraction}{Attraction, expansion phase.}
\item{expansion.damping.mult}{Damping, expansion phase.}
\item{cooldown.iterations}{Number of iterations, cooldown phase.}
\item{cooldown.temperature}{Start temperature, cooldown phase.}
\item{cooldown.attraction}{Attraction, cooldown phase.}
\item{cooldown.damping.mult}{Damping, cooldown phase.}
\item{crunch.iterations}{Number of iterations, crunch phase.}
\item{crunch.temperature}{Start temperature, crunch phase.}
\item{crunch.attraction}{Attraction, crunch phase.}
\item{crunch.damping.mult}{Damping, crunch phase.}
\item{simmer.iterations}{Number of iterations, simmer phase.}
\item{simmer.temperature}{Start temperature, simmer phase.}
\item{simmer.attraction}{Attraction, simmer phase.}
\item{simmer.damping.mult}{Damping, simmer phase.}

There are five pre-defined parameter settings as well, these are called
\code{drl_defaults$default}, \code{drl_defaults$coarsen},
\code{drl_defaults$coarsest}, \code{drl_defaults$refine} and
\code{drl_defaults$final}.  }
}
\examples{

g <- as.undirected(sample_pa(100, m = 1))
l <- layout_with_drl(g, options = list(simmer.attraction = 0))
plot(g, layout = l, vertex.size = 3, vertex.label = NA)

}
\references{
See the following technical report: Martin, S., Brown, W.M.,
Klavans, R., Boyack, K.W., DrL: Distributed Recursive (Graph) Layout. SAND
Reports, 2008. 2936: p. 1-10.
}
\seealso{
\code{\link[=layout]{layout()}} for other layout generators.
}
\author{
Shawn Martin (\url{http://www.cs.otago.ac.nz/homepages/smartin/})
and Gabor Csardi \email{csardi.gabor@gmail.com} for the R/igraph interface
and the three dimensional version.
}
\concept{layout_drl}
\keyword{graphs}
