% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\docType{methods}
\name{add_col_clustering}
\alias{add_col_clustering}
\alias{add_col_clustering,Iheatmap-method}
\title{add_col_clustering}
\usage{
\S4method{add_col_clustering}{Iheatmap}(p, method = c("hclust", "kmeans",
  "groups"), name = "Col<br>Clusters", k = NULL, groups = NULL,
  clust_dist = stats::dist, colors = NULL, show_colorbar = TRUE,
  side = c("top", "bottom"), yname = NULL, xname = current_xaxis(p))
}
\arguments{
\item{p}{iheatmap object}

\item{method}{"hclust" or "kmeans" for hierarchical or k-means clustering, 
respectively}

\item{name}{name of colorbar indicating cluster membership}

\item{k}{number of clusters for rows, needed if order is kmeans or optional 
if hclust}

\item{groups}{vector of group assignments}

\item{clust_dist}{distance function to use for clustering if hierarchical 
clustering}

\item{colors}{colors to use for annotation of grouping, can be RColorBrewer 
palette name or
vector of colors}

\item{show_colorbar}{show the colorbar for the heatmap indicating cluster 
membership}

\item{side}{side of plot on which to add subplot}

\item{yname}{name of yaxis}

\item{xname}{name of xaxis}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
add_col_clustering
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)
hm <- iheatmap(mat) \%>\% add_col_clustering(method = "hclust", k = 2)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_clustering}}, \code{\link{iheatmap}}
}
\author{
Alicia Schep
}
