% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{display}
\alias{display}
\title{Basic image display.}
\usage{
display(img, ...)
}
\arguments{
\item{img}{An \link{ijtiff_img} object.}

\item{...}{Passed to \code{imager}'s `plot.cimg().}
}
\description{
Display an image that has been read in by \code{\link[=read_tif]{read_tif()}} as it would look in
'ImageJ'. This function is really just \code{imager}'s \code{plot.cimg()} on the
inside, with some handling.
}
\examples{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
display(img)
display(img[, , 1, 1]) # first (red) channel, first frame
display(img[, , 2, ]) # second (green) channel, first frame
display(img[, , 3, ]) # third (blue) channel, first frame
display(img, basic = TRUE) # displays first (red) channel, first frame

}
