% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_hclust}
\alias{vis.immunr_hclust}
\title{Visualisation of hierarchical clustering}
\usage{
\method{vis}{immunr_hclust}(.data, .rect = FALSE, .plot = c("clust", "best"), ...)
}
\arguments{
\item{.data}{Clustering results from \link{repOverlapAnalysis} or \link{geneUsageAnalysis}.}

\item{.rect}{Passed to \link{fviz_dend} - whether to add a rectangle around groups.}

\item{.plot}{A character vector of length one or two specifying which plots to visualise.
If "clust" then plot only the clustering. If "best" then plot the number of optimal clusters.
If both then plot both.}

\item{...}{Not used here.}
}
\value{
Ggplot2 objects inside the patchwork container.
}
\description{
Visualisation of the results of hierarchical clustering.
For other clustering visualisations see \link{vis.immunr_kmeans}.
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data)
repOverlapAnalysis(ov, "mds+hclust") \%>\% vis()
}
\seealso{
\link{vis}, \link{repOverlapAnalysis}, \link{geneUsageAnalysis}
}
\concept{post_analysis}
