% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_mismatch_base.R
\name{HLA_mismatch_base}
\alias{HLA_mismatch_base}
\title{HLA_mismatch_base}
\usage{
HLA_mismatch_base(
  GL_string_recip,
  GL_string_donor,
  loci,
  direction,
  homozygous_count = 2
)
}
\arguments{
\item{GL_string_recip}{A GL string representing the recipient's HLA genotype.}

\item{GL_string_donor}{A GL string representing the donor's HLA genotype.}

\item{loci}{A character vector specifying the loci to be considered for
mismatch calculation. HLA-DRB3/4/5 (and their serologic equivalents DR51/52/53)
are considered once locus for this function, and should be called in this argument
as "HLA-DRB3/4/5" or "HLA-DR51/52/53", respectively.}

\item{direction}{A character string indicating the direction of mismatch.
Options are "HvG" (host vs. graft) or "GvH" (graft vs. host).}

\item{homozygous_count}{An integer specifying how to handle homozygosity.
Defaults to 2, where homozygous alleles are treated as duplicated for
mismatch calculations. Can be specified to be 1, in which case homozygous
alleles are treated as single occurrences without duplication.}
}
\value{
A character vector, where each element is a string summarizing the
mismatches for the specified loci. The strings are formatted as
comma-separated locus mismatch entries if multiple loci are supplied, or
simple GL strings if a single locus is supplied.
}
\description{
A function to return a string of mismatches between recipient
and donor HLA genotypes represented as GL strings. The function finds
mismatches based on the direction of comparison specified in the inputs
and also handles homozygosity. As the name implies, this function is the base
for all other mismatch (and matching) functions. This function is not meant to be
called directly; it is better to use one of the derivative functions.
}
\examples{
file <- HLA_typing_1[, -1]
GL_string <- HLA_columns_to_GLstring(file, HLA_typing_columns = everything())

GL_string_recip <- GL_string[1]
GL_string_donor <- GL_string[2]

loci <- c("HLA-A", "HLA-DRB3/4/5", "HLA-DPB1")
mismatches <- HLA_mismatch_base(GL_string_recip, GL_string_donor, loci, direction = "HvG")
print(mismatches)

}
