% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_wear.R
\name{remove_nonwear}
\alias{remove_nonwear}
\title{Detect and remove accelerometer non-wear time}
\usage{
remove_nonwear(
  data,
  window1 = 60,
  window2 = 15,
  threshold = 2,
  min_hour_crit = 0,
  min_day_crit = 0,
  plot = FALSE,
  save_plot = FALSE,
  save_summary = FALSE
)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{window1, window2}{Windows size, in minutes, for the non-wear
detection algorithm. Defaults to 60 and 15 minutes, respectively.
Also, \code{window2} must be smaller than \code{window1}, and
\code{window1} must be a multiple of \code{window2}.}

\item{threshold}{Number of axes that need to meet the non-wear criteria.
Defaults to 2.}

\item{min_hour_crit}{The minimum number of hours marked as wear time
in a day for it to be considered valid (see Data validation).
Defaults to 0, meaning that every day is considered valid.}

\item{min_day_crit}{The minimum number of valid days for the data of
a given subject to be considered valid (see Data validation).
Defaults to 0, meaning that all data is valid.}

\item{plot}{A logical value indicating whether or not to display the
plot to visualize the detected non-wear periods. Defaults to \code{FALSE}.
Notice that the plot will only be displayed in your R session if you do
not provide a path to save the plot (see the argument \code{save_plot}).}

\item{save_plot, save_summary}{Indicates whether of not to save the plot to
visualize the detected non-wear periods to a pdf file and the wear time
daily summary to a csv file, respectively. Defaults to \code{FALSE}.
Provide a valid path to a file, ending with the ".pdf" extension for the
plot or with the ".csv" extension to the summary, as a character string
if you want the outputs to be saved.}
}
\value{
An object of class \code{impactr_data} and a plot if
\code{plot = TRUE} and \code{save_plot = FALSE}.
}
\description{
Detects the accelerometer non-wear time based on an algorithm developed
by van Hees (see Details) and remove these periods from the raw data. This
function can also draw a plot to better visualize the detected non-wear
periods and generate a wear time daily summary.
}
\section{The non-wear detection algorithm}{


The current version of this algorithm is described in a paper by van Hees
et al (see References) and also in this
\href{https://CRAN.R-project.org/package=GGIR/vignettes/GGIR.html#53_Non-wear_detection}{vignette} from package GGIR.
Briefly, in a first stage it identifies non-wear time based on threshold
values of standard deviation (0.013\emph{g}) and range (0.050\emph{g}) of
raw acceleration from each axis. The classification is done per blocks of
\code{window2} size (default 15 minutes) based on the characteristics of
a larger \code{window1} (default 60 minutes) centred at the
\code{window2}. In the second stage of the algorithm, the plausibility of
wear periods in between non-wear periods is tested based on the duration
and proportion of the duration relative to the surrounding non-wear
periods.
}

\section{Data validation}{


After the detection of non-wear periods through the algorithm, a data
validation step is applied. For each measurement day to be considered
valid, it has to present a minimum number of wear time hours determined
by the \code{min_hour_crit} argument. If the number of wear time hours of
a given day falls below the threshold, the whole day is considered invalid
and is then removed from the subsequent analyses. The whole measurement
is also classified as valid or invalid based on the number of valid days
and a threshold given by \code{min_day_crit}. If the number of valid days
is less than the value determined by the \code{min_day_crit} argument,
the whole data is deleted and the \code{remove_nonwear()} function
signals an error, stopping its execution. Nevertheless, this error does
not prevent the plot to be displayed or saved, or the wear time daily
summary to be saved, if the arguments are set to do so.
}

\examples{
# Ensure that {accdata} package is available before running the example.
# If it is not, run install_accdata() to install the required package.
if (requireNamespace("accdata", quietly = TRUE)) {
  data <- import_dataset("daily_acc_3d")
  remove_nonwear(data)
}
}
\references{
\itemize{
\item van Hees VT, Gorzelniak L, Dean León EC, Eder M, Pias M, Taherian S,
Ekelund U, Renström F, Franks PW, Horsch A, Brage S. Separating movement
and gravity components in an acceleration signal and implications for the
assessment of human daily physical activity. PLoS One. 2013. Apr 23.
\doi{https://doi.org/10.1371/journal.pone.0061691}.
}
}
