% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_poblacion_rural.R
\name{censo_poblacion_rural}
\alias{censo_poblacion_rural}
\title{Censo de Poblacion - Localidades rurales}
\usage{
censo_poblacion_rural(year = NA, estado = "Nacional")
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. El unico año disponible en INEGI (incluyendo los conteos) es 2010.}

\item{estado}{Define el nombre de la entidad federativa para descargar los datos en formato alfanumerico. La funcion, por defecto utiliza la palabra "Nacional" para descargar los datos de todos los estados. Los nombres de los estados deben ir capitalizados (y en su caso, con espacios), por ejemplo: "Aguascalientes", "CDMX", "San Luis Potosi".}
}
\value{
Data.frame
}
\description{
Censo de Poblacion y Vivienda. Resultados sobre localidades con menos de 5 mil habitantes
}
\details{
Esta base de datos tiene dos niveles de agregacion: entidades federativas y municipios.
}
\examples{

# Descargar los datos de CDMX de 2010.
\donttest{rural = censo_poblacion_rural(year = 2010, estado = "CDMX")}
}
