% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNA.gapsize.R
\name{plotNA.gapsize}
\alias{plotNA.gapsize}
\title{Visualize Distribution of NA gapsizes}
\usage{
plotNA.gapsize(x, limit = 10, byTotalNA = F, legend = T,
  col = c("indianred", "steelblue"),
  xlab = "Ranking of the different gapsizes", ylab = "Number",
  main = "Occurance of  gapsizes (NAs in a row)", cex.names = 0.7,
  horiz = F, axes = T, beside = T, las = 1, ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object containing NAs}

\item{limit}{Specifies how many of the top gapsizes are shown in the plot.}

\item{byTotalNA}{For byTotalNA = TRUE the top gapsizes according to their overall weight are shown. (occurence * gapsize)
For byTotalNA = FALSE the top gapsizes are shown by their number of occurence. (occurence)}

\item{legend}{If TRUE a legend is shown at the bottom of the plot. A custom legend can be obtained by
setting this parameter to FALSE and using  \code{\link[graphics]{legend}} function}

\item{col}{A vector of colors for the bars or bar components.}

\item{xlab}{Label for x axis of the plot}

\item{ylab}{Label for y axis of plot}

\item{main}{Main title for the plot}

\item{cex.names}{Expansion factor for axis names (bar labels).}

\item{horiz}{A logical value. If FALSE, the bars are drawn vertically with the first bar to the left. If TRUE, the bars are drawn horizontally with the first at the bottom.}

\item{axes}{Logical. If TRUE, a vertical (or horizontal, if horiz is true) axis is drawn.}

\item{beside}{A logical value. If FALSE, the columns of height are portrayed as stacked bars, and if TRUE the columns are portrayed as juxtaposed bars.}

\item{las}{Numeric in {0,1,2,3}; the style of axis labels. 0:always parallel to the axis, 1:always horizontal, 2:always perpendicular to the axis, 3:always vertical.}

\item{...}{Additional graphical parameters that can be passed through to barplot}
}
\description{
Visualize Distribution of NA gapsizes(NAs in a row) in a time series
}
\details{
This plotting function can be used to visualize the length of the NA gaps(NAs in a row)
 in a time series. It shows a ranking of which gapsizes occur most often. This ranking can be ordered by total NAs for this gapsize (occurence * gap length) or by occurence of the gapsize.
 The outcome will be somethink like in the time series 2NAs in a row occured 27times, 4NAs in a row occured 11 times, 
 7NAs in a row occured 5 times, 1NA in a row occured 3 times,... .
}
\examples{
#Prerequisite: Load a time series with missing values
x <-tsNH4

#Example 1: Visualize the top gapsizes
plotNA.gapsize(x)

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{plotNA.distribution}},\code{\link[imputeTS]{plotNA.distributionBar}},
  \code{\link[imputeTS]{plotNA.imputations}}
}

