% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inTextSummaryTable-common-args-doc.R
\name{inTextSummaryTable-flextable-args}
\alias{inTextSummaryTable-flextable-args}
\title{Common arguments for the functionalities of the inTextSummaryTable package
for flextable export.}
\arguments{
\item{style}{(flextable output) String with table style,
 either 'report' or 'presentation'.
This parameter affects the fontsize, font family, color of the text and background, 
and table dimensions of the table.}

\item{rowTotalLab}{(flextable output) string with label for the row with total.}

\item{rowAutoMerge}{(flextable output) Logical, if TRUE (by default) automatically merge rows,
e.g. in case there is only one sub-category (e.g. categorical variable with only one group)
or only one statistic per category.}

\item{rowVarFormat}{(flextable output) Named list with special formatting for the \code{rowVar}.
Currently, only possibility is to set the variable elements in bold, with:
list(var1 = "bold").
(Use 'variable' for \code{var} or 'variableGroup' for group within categorical variables.)}

\item{rowPadBase}{(flextable output) Base padding for row (in points), 
14.4 by default (corresponds to 0.2 inches)}

\item{fontname}{(flextable output) String with font name, by default:
'Times' if \code{style} is 'report' and 'Tahoma' if \code{style} is 'presentation'.}

\item{fontsize}{(flextable output) Integer with font size, by default:
8 if \code{style} is 'report' and 10 if \code{style} is 'presentation'.}

\item{margin}{(flextable output) Margin in the document in inches
(1 by default).
This is used to specify the width of the table, from:
[\code{pageDim[1]} - 2 * margin].}

\item{colorTable}{(flextable output) Named character vector with color for the table background/body/text/line,
e.g. created with the \code{\link{getColorPaletteTable}} function.}

\item{landscape}{(flextable output) Logical, if TRUE the file is in landscape format.\cr
By default: FALSE if \code{style} is 'report' and TRUE if \code{style} is 'presentation'.}

\item{footer}{(flextable output) Character vector with footer(s) for the table.
Set to NULL (by default) if no footer should be included.}

\item{vline}{(flextable output) String mentioning how vertical lines 
should be included in the body of the table, either: 
\itemize{
\item{'none' (default): }{no vertical lines included}
\item{'auto': }{vertical lines included between sub-groups}
}}

\item{hline}{(flextable output) String mentioning how horizontal lines 
should be included in the body of the table, either: 
\itemize{
\item{'none': }{no horizontal lines included}
\item{'auto' (default): }{horizontal lines included between sub-groups}
}}

\item{file}{String with path of the file where the table should be exported.
The file should have the extension: '.html'.
If NULL, the summary table is not exported but only returned as output.
If \code{byVar} is specified, each table is exported to a separated
file with the suffix: 'file_[i].html' with i the index of the file.}

\item{colHeaderMerge}{(flextable output) Logical, if TRUE (FALSE by default) 
the column header is merged.}
}
\value{
No return value, used for the documentation of 
R functions for 'flextable' output
}
\description{
Common arguments for the functionalities of the inTextSummaryTable package
for flextable export.
}
