% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{confint.incubate_fit}
\alias{confint.incubate_fit}
\title{Confidence intervals for parameters of MPS-model fits.}
\usage{
\method{confint}{incubate_fit}(
  object,
  parm,
  level = 0.95,
  R = 199L,
  bs_data,
  bs_infer = c("logquantile", "quantile", "quantile0", "lognormal", "normal",
    "normal0", "t", "t0"),
  useBoot = FALSE,
  logshift_delay = 3,
  smd_factor = 0.1,
  ...
)
}
\arguments{
\item{object}{object of class \code{incubate_fit}}

\item{parm}{character. Which parameters to get confidence interval for?}

\item{level}{numeric. Which is the requested confidence level for the interval? Default value is 0.95}

\item{R}{number of bootstrap replications. Used only if not \code{bs_data}-object is provided.}

\item{bs_data}{character or bootstrap data object. If character, it specifies which type of bootstrap is requested and the bootstrap data will be generated. Data can also be provided here directly. If missing it uses parametric bootstrap.}

\item{bs_infer}{character. Which type of bootstrap inference is requested to generate the confidence interval?}

\item{useBoot}{logical. Delegate bootstrap confint calculation to the \code{boot}-package?}

\item{logshift_delay}{numeric. Used for log-transforms only. Positive number what to add to delay fit distribution once the minimum has been subtracted. Then log is applied. Default is .01}

\item{smd_factor}{numeric. How much should the delay parameter be smoothed? Only supported for parametric bootstrap. And only used if no \code{bs_data}- object is provided.}

\item{...}{further arguments, currently not used.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter.
}
\description{
Bias-corrected bootstrap confidence limits (either quantile-based or normal-approximation based) are generated.
Optionally, there are also variants that use a log-transformation first.
At least R=1000 bootstrap replications are recommended. Default are normal-based confidence intervals.
}
