% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R
\name{Event}
\alias{Event}
\title{Event Class}
\description{
Describes a general event in the simulation
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Event$new()}}
\item \href{#method-add_listener}{\code{Event$add_listener()}}
\item \href{#method-schedule}{\code{Event$schedule()}}
\item \href{#method-clear_schedule}{\code{Event$clear_schedule()}}
\item \href{#method-.tick}{\code{Event$.tick()}}
\item \href{#method-.process}{\code{Event$.process()}}
\item \href{#method-.process_listener}{\code{Event$.process_listener()}}
\item \href{#method-.process_listener_cpp}{\code{Event$.process_listener_cpp()}}
\item \href{#method-clone}{\code{Event$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialise an Event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_listener"></a>}}
\if{latex}{\out{\hypertarget{method-add_listener}{}}}
\subsection{Method \code{add_listener()}}{
Add an event listener
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$add_listener(listener)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{listener}}{the function to be executed on the event, which takes a single
argument giving the time step when this event is triggered.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-schedule"></a>}}
\if{latex}{\out{\hypertarget{method-schedule}{}}}
\subsection{Method \code{schedule()}}{
Schedule this event to occur in the future
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$schedule(delay)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{delay}}{the number of time steps to wait before triggering the event,
can be a scalar or an vector of values for events that should be triggered
multiple times.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-clear_schedule}{}}}
\subsection{Method \code{clear_schedule()}}{
Stop a future event from triggering
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$clear_schedule()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.tick"></a>}}
\if{latex}{\out{\hypertarget{method-.tick}{}}}
\subsection{Method \code{.tick()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$.tick()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.process"></a>}}
\if{latex}{\out{\hypertarget{method-.process}{}}}
\subsection{Method \code{.process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$.process()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.process_listener"></a>}}
\if{latex}{\out{\hypertarget{method-.process_listener}{}}}
\subsection{Method \code{.process_listener()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$.process_listener(listener)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.process_listener_cpp"></a>}}
\if{latex}{\out{\hypertarget{method-.process_listener_cpp}{}}}
\subsection{Method \code{.process_listener_cpp()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$.process_listener_cpp(listener)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Event$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
