% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired-ttest.R
\name{paired_ttest}
\alias{paired_ttest}
\title{Paired t test}
\usage{
paired_ttest(x, y, confint = 0.95, alternative = c("both", "less",
  "greater", "all"))
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric vector}

\item{confint}{confidence level}

\item{alternative}{a character string specifying the alternative hypothesis, must be
one of "both" (default), "greater", "less" or "all". You can specify just the
initial letter.}
}
\value{
\code{paired_ttest} returns an object of class \code{"paired_ttest"}.
An object of class \code{"paired_ttest"} is a list containing the
following components:

\item{Obs}{number of observations}
\item{b}{mean, standard deviation and standard error of \code{x}, \code{y}
and their difference}
\item{tstat}{t statistic}
\item{p_lower}{lower one-sided p-value}
\item{p_upper}{upper one-sided p-value}
\item{p_two_tail}{two sided p-value}
\item{corr}{Correlation of \code{x} and \code{y}}
\item{corsig}{p-value of correlation test}
\item{conf_int1}{confidence interval for mean of \code{x}}
\item{conf_int2}{confidence interval for mean of \code{y}}
\item{conf_int_diff}{confidence interval for mean of difference of \code{x}
and \code{y}}
\item{df}{degrees of freedom}
\item{confint}{confidence level}
\item{alternative}{alternative hypothesis}
\item{var_names}{names of \code{x} and \code{y}}
\item{xy}{string used in printing results of the test}
}
\description{
\code{paired_ttest} tests that two samples have the
same mean, assuming paired data.
}
\examples{
# lower tail
paired_ttest(hsb$read, hsb$write, alternative = 'less')

# upper tail
paired_ttest(hsb$read, hsb$write, alternative = 'greater')

# both tails
paired_ttest(hsb$read, hsb$write, alternative = 'both')

# all tails
paired_ttest(hsb$read, hsb$write, alternative = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{t.test}}
}

