% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru.options}
\alias{bru.options}
\title{Additional \link{bru} options}
\usage{
bru.options(mesh = NULL, run = TRUE, max.iter = 10, offset = 0,
  result = NULL, E = 1, control.compute = list(config = TRUE, dic = TRUE,
  waic = TRUE), control.inla = iinla.getOption("control.inla"), ...)
}
\arguments{
\item{mesh}{An \code{inla.mesh} object for spatial models without SPDE components. Mostly used for successive spatial predictions.}

\item{run}{If TRUE, run inference. Otherwise only return configuration needed to run inference.}

\item{max.iter}{maximum number of inla iterations}

\item{offset}{the usual \link[INLA]{inla} offset. If a nonlinear formula is used, the resulting Taylor approximation constant will be added to this automatically.}

\item{result}{An \code{inla} object returned from previous calls of \link[INLA]{inla}, \link{bru} or \link{lgcp}. This will be used as a starting point for further improvement of the approximate posterior.}

\item{E}{\link[INLA]{inla} exposure parameter}

\item{control.compute}{INLA option, See \link[INLA]{control.compute}}

\item{control.inla}{INLA option, See \link[INLA]{control.inla}}

\item{...}{Additional options passed on to \link[INLA]{inla}}
}
\description{
Additional \link{bru} options
}
\examples{

\dontrun{

# Generate default bru options
opts = bru.options()

# Print them:
opts

}

}
\author{
Fabian E. Bachl <\email{bachlfab@gmail.com}>
}
