% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.sf}
\alias{gg.sf}
\title{Geom helper for sf objects}
\usage{
\method{gg}{sf}(data, mapping = NULL, ..., geom = "sf")
}
\arguments{
\item{data}{An \code{sf} object.}

\item{mapping}{Default mapping is \code{ggplot2::aes(geometry = ...)},
where the geometry name is obtained from \code{attr(data, "sf_column")}.
This is merged with the user supplied mapping.}

\item{...}{Arguments passed on to \code{geom_sf} or \code{geom_tile}.}

\item{geom}{Either "sf" (default) or "tile". For "tile", uses
\code{geom_tile(..., stat = "sf_coordinates")}, intended for converting point data
to grid tiles with the \code{fill} aesthetic, which is by default set to the first
data column.}
}
\value{
A ggplot return value
}
\description{
This function uses \code{geom_sf()}, unless overridden by the geom argument.
Requires the \code{ggplot2} package.
}
\seealso{
Other geomes for spatial data: 
\code{\link{gg}()},
\code{\link{gg.SpatRaster}()},
\code{\link{gg.SpatialGridDataFrame}()},
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg.SpatialPolygons}()},
\code{\link{gm}()}
}
\concept{geomes for spatial data}
