% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.robins_subset.R
\docType{data}
\name{robins_subset}
\alias{robins_subset}
\title{robins_subset}
\format{
The data are a data.frame with variables
\describe{
\item{\code{circle}:}{
Four-letter code of the CBC circle.
}
\item{\code{bcr}:}{
Numeric code for the bird conservation region encompassing the
count circle.
}
\item{\code{state}:}{
US state encompassing the count circle.
}
\item{\code{year}:}{
calendar year the count was conducted.
}
\item{\code{std_yr}:}{
transformed year, with 2016 = 0.
}
\item{\code{count}:}{
number of robins recorded.
}
\item{\code{log_hrs}:}{
the natural log of party hours.
}
\item{\code{lon}:}{
longitude of the count circle centroid.
}
\item{\code{lat}:}{
latitude of the count circle centroid.
}
\item{\code{obs}:}{
unique record identifier.
}
}
}
\source{
https://github.com/tmeeha/inlaSVCBC
}
\usage{
robins_subset
}
\description{
This is the \code{robins_subset} dataset, which is a subset of the
full robins data set used to demonstrate a spatially varying trend
coefficient model in Meehan et al. 2019. The dataset includes American
Robin counts, along with time, location, and effort information, from
Audubon Christimas Bird Counts (CBC) conducted in six US states between
1987 and 2016.
}
\examples{
if (require(ggplot2, quietly = TRUE)) {
  data(robins_subset, package = "inlabru") # get the data

  # plot the counts for one year of data
  ggplot(robins_subset[robins_subset$std_yr == 0, ]) +
    geom_point(aes(lon, lat, colour = count + 1)) +
    scale_colour_gradient(low = "blue", high = "red", trans = "log")
}
}
\references{
Meehan, T.D., Michel, N.L., and Rue, H. 2019. Spatial modeling of Audubon
Christmas Bird Counts reveals fine-scale patterns and drivers of relative
abundance trends. Ecosphere, 10(4), p.e02707.
}
\keyword{datasets}
