% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReplaceInTemplate.R
\name{ReplaceInTemplate}
\alias{ReplaceInTemplate}
\title{Replace Values in a Template Text}
\usage{
ReplaceInTemplate(text, replacement)
}
\arguments{
\item{text}{character.
Vector of character strings, that is the template text.}

\item{replacement}{list.
Values to replace in \code{text}.}
}
\value{
Returns a vector of character strings after key replacement.
}
\description{
This function replaces keys within special markups in a template text with specified values.
Pieces of \R code can be put into the markups of the template text,
and are evaluated during the replacement.
}
\details{
Keys are enclosed into markups of the form $(KEY) and @\{CODE\}.
}
\examples{
text <- c("Hello $(name)!", "$(a) + $(b) = @{$(a) + $(b)}",
          "pi = @{format(pi, digits = 5)}")
replacement <- list(name = "world", a = 1, b = 2)
cat(ReplaceInTemplate(text, replacement), sep = "\\n")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\references{
This code was derived from the
  \href{https://CRAN.R-project.org/package=sensitivity}{sensitivity}\code{::template.replace} function,
  accessed on Feb 6, 2015 (https://CRAN.R-project.org/package=sensitivity).
}
\seealso{
\code{\link{SummariseBudget}}
}
\keyword{IO}

