% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormatPval.R
\name{FormatPval}
\alias{FormatPval}
\title{Format P Values}
\usage{
FormatPval(x, digits = max(1, getOption("digits") - 2),
  eps = .Machine$double.eps, na.form = "NA", scientific = NA)
}
\arguments{
\item{x}{'numeric' vector.
\emph{p}-values}

\item{digits}{'integer' count.
Number of significant digits to be used.}

\item{eps}{'numeric' number.
Numerical tolerance,
values less than \code{eps} are formatted as \code{"< [eps]"}.}

\item{na.form}{'character' string.
Value used for missing values.}

\item{scientific}{'logical' flag.
Whether values should be encoded in scientific format using LaTeX notation.
A missing value lets \R decide whether fixed or scientific notation is used.}
}
\value{
A 'character' vector of formatted \emph{p}-values.
}
\description{
Format \emph{p}-values for pretty printing.
}
\examples{
x <- c(stats::runif(5), pi^-100, NA)
FormatPval(x)
format.pval(x)

x <- c(0.1, 0.0001, 1e-27)
FormatPval(x, scientific = TRUE)
FormatPval(x, digits = 3, eps = 0.001)

}
\seealso{
\code{\link{ToScientific}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
