% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_PRO_processTxt.R
\name{postProcTxt}
\alias{postProcTxt}
\title{Prossess vectors containing words into a data.frame of word occurrences.}
\usage{
postProcTxt(txt, minword = 1, maxword = 20, minFreqWord = 1)
}
\arguments{
\item{txt}{A vector containing text.}

\item{minword}{An integer specifying the minimum number of letters per word into the returned data.frame.}

\item{maxword}{An integer to specifying the maximum number of letters per word into the returned data.frame.}

\item{minFreqWord}{An integer specifying the minimum word frequency into the returned data.frame.}
}
\value{
A data.frame (freq = occurrences, stem = stem words, word = words), sorted by word occurrences.
}
\description{
Prossess vectors containing words into a data.frame of word occurrences.
}
\examples{
\dontrun{
postProcTxt(txt = preProcTxt(filetxt = "loremIpsum.txt"))
}
data("loremIpsum")
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum, file = "RESULTS/loremIpsum.txt")
preProcTxt(filetxt = paste0(getwd(), "/RESULTS/loremIpsum.txt"))
postProcTxt(txt = preProcTxt(filetxt = paste0(getwd(), "/RESULTS/loremIpsum.txt")))
file.remove(list.files(pattern = "loremIpsum"))
}
