## ----setup,echo=FALSE, include=FALSE------------------------------------------
# setup chunk
NOT_CRAN <- identical(tolower(Sys.getenv("NOT_CRAN")),"true")
knitr::opts_chunk$set(purl = NOT_CRAN)
library(insee)
library(tidyverse)

embed_png <- function(path, dpi = NULL) {
  meta <- attr(png::readPNG(path, native = TRUE, info = TRUE), "info")
  if (!is.null(dpi)) meta$dpi <- rep(dpi, 2)
  knitr::asis_output(paste0(
    "<img src='", path, "'",
    " width=", round(meta$dim[1] / (meta$dpi[1] / 96)),
    " height=", round(meta$dim[2] / (meta$dpi[2] / 96)),
    " />"
  ))}

## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(kableExtra)
library(magrittr)
library(htmltools)
library(prettydoc)

## ---- echo = FALSE------------------------------------------------------------
embed_png("pop_map.png")

## ----message=FALSE, warning=FALSE,eval=FALSE----------------------------------
#  library(insee)
#  library(tidyverse)
#  
#  library(raster)
#  library(rgdal)
#  library(broom)
#  library(viridis)
#  
#  idbank_list = get_idbank_list()
#  
#  dataset_list = get_dataset_list()
#  
#  list_idbank = idbank_list %>%
#    filter(nomflow == "TCRED-ESTIMATIONS-POPULATION") %>%
#    filter(dim6 == "00-") %>% #all ages
#    filter(dim5 == 0) %>% #men and women
#    filter(str_detect(dim4, "^D")) %>% #select only departements
#    mutate(title = get_insee_title(idbank))
#  
#  list_idbank_selected = list_idbank %>% pull(idbank)
#  
#  # get population data by departement
#  pop = get_insee_idbank(list_idbank_selected)
#  
#  #get departements' geographical limits
#  FranceMap <- raster::getData(name = "GADM", country = "FRA", level = 2)
#  
#  # extract the population by departement in 2020
#  pop_plot = pop %>%
#    group_by(TITLE_EN) %>%
#    filter(DATE == "2020-01-01") %>%
#    mutate(dptm = gsub("D", "", REF_AREA)) %>%
#    filter(dptm %in% FranceMap@data$CC_2) %>%
#    mutate(dptm = factor(dptm, levels = FranceMap@data$CC_2)) %>%
#    arrange(dptm) %>%
#    mutate(id = dptm)
#  
#  vec_pop = pop_plot %>% pull(OBS_VALUE)
#  
#  # add population data to the departement object map
#  FranceMap@data$pop = vec_pop
#  
#  # extract the departements' limits from the spatial object
#  FranceMap_tidy <- broom::tidy(FranceMap)
#  
#  # mapping table
#  dptm_df = data.frame(dptm = FranceMap@data$CC_2,
#                       dptm_name = FranceMap@data$NAME_2,
#                       pop = FranceMap@data$pop,
#                       id = rownames(FranceMap@data))
#  
#  # add population data to departement dataframe
#  FranceMap_tidy_final =
#    FranceMap_tidy %>%
#    left_join(dptm_df, by = "id") %>%
#    dplyr::select(long, lat, pop, group, id)
#  
#  ggplot() +
#    geom_polygon(data = FranceMap_tidy_final,
#                 aes(fill = pop, x = long, y = lat, group = group) ,
#                 size = 0, alpha = 0.9) +
#    coord_map() +
#    theme_void() +
#    scale_fill_viridis() +
#    ggtitle("Distribution of the population within French territory in 2020")
#  

